/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.remoting.transport.async;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.geronimo.proxy.SimpleContainer;
import org.apache.geronimo.remoting.router.Router;
import org.apache.geronimo.remoting.transport.TransportServer;
import org.apache.geronimo.remoting.transport.async.ChannelPool;
import org.apache.geronimo.remoting.transport.async.Registry;

public abstract class AbstractServer
extends SimpleContainer
implements TransportServer {
    public final long CONNECTION_TIMEOUT = Long.parseLong(System.getProperty("org.apache.geronimo.remoting.transport.async.connection_timeout", "300000"));
    private HashMap uriTo = new HashMap();
    private HashMap channelPools = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelPool getChannelPool(URI uri) {
        URIKey key = new URIKey(uri);
        HashMap hashMap = this.channelPools;
        synchronized (hashMap) {
            ChannelPool rc = (ChannelPool)this.channelPools.get(key);
            if (rc == null) {
                rc = new ChannelPool(uri, this.getNextRouter());
                this.channelPools.put(key, rc);
                ChannelPoolMonitor pm = new ChannelPoolMonitor(key, rc);
                pm.clockTicket = Registry.instance.getClockDaemon().executePeriodically(this.CONNECTION_TIMEOUT, (Runnable)pm, true);
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() throws Exception {
        HashMap hashMap = this.channelPools;
        synchronized (hashMap) {
            Iterator iterator = this.channelPools.values().iterator();
            while (iterator.hasNext()) {
                ChannelPool pool = (ChannelPool)iterator.next();
                pool.dispose();
                iterator.remove();
            }
        }
    }

    public abstract Router getNextRouter();

    public void start() throws Exception {
        if (Registry.instance.getDefaultServer() == null) {
            Registry.instance.setDefaultServer(this);
        }
    }

    public void stop() throws Exception {
        if (Registry.instance.getDefaultServer() == this) {
            Registry.instance.setDefaultServer(null);
        }
    }

    class ChannelPoolMonitor
    implements Runnable {
        long age = System.currentTimeMillis();
        URIKey key;
        ChannelPool channelPool;
        Object clockTicket;

        ChannelPoolMonitor(URIKey key, ChannelPool cp) {
            this.key = key;
            this.channelPool = cp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.channelPool.expireIdleConnections(AbstractServer.this.CONNECTION_TIMEOUT);
            if (System.currentTimeMillis() - this.age < AbstractServer.this.CONNECTION_TIMEOUT) {
                return;
            }
            HashMap hashMap = AbstractServer.this.channelPools;
            synchronized (hashMap) {
                if (this.channelPool.getCreatedChannelCount() == 0) {
                    ClockDaemon.cancel((Object)this.clockTicket);
                }
                AbstractServer.this.channelPools.remove(this.key);
            }
        }
    }

    private class URIKey {
        String ipaddress;
        int port;

        URIKey(URI uri) {
            this.ipaddress = uri.getHost();
            this.port = uri.getPort();
        }

        public boolean equals(Object obj) {
            return ((URIKey)obj).port == this.port && ((URIKey)obj).ipaddress.equals(this.ipaddress);
        }

        public int hashCode() {
            return this.ipaddress.hashCode() + this.port;
        }
    }
}

