/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.remoting.transport;

import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.remoting.router.Router;
import org.apache.geronimo.remoting.transport.TransportFactory;
import org.apache.geronimo.remoting.transport.TransportServer;

public class TransportLoader
implements GBeanLifecycle {
    private static final Log log = LogFactory.getLog((Class)TransportLoader.class);
    private URI bindURI;
    private TransportServer transportServer;
    private Router router;
    public static final GBeanInfo GBEAN_INFO;

    public URI getBindURI() {
        return this.bindURI;
    }

    public void setBindURI(URI bindURI) {
        this.bindURI = bindURI;
    }

    public Router getRouter() {
        return this.router;
    }

    public void setRouter(Router router) {
        this.router = router;
    }

    public URI getClientConnectURI() {
        if (this.transportServer == null) {
            return null;
        }
        return this.transportServer.getClientConnectURI();
    }

    public void doStart() throws Exception {
        if (this.router == null) {
            throw new IllegalStateException("Target router was not set.");
        }
        TransportFactory tf = TransportFactory.getTransportFactory(this.bindURI);
        this.transportServer = tf.createSever();
        this.transportServer.bind(this.bindURI, this.router);
        this.transportServer.start();
        log.info((Object)("Started transport loader, listening to " + this.bindURI));
    }

    public void doStop() throws Exception {
        if (this.transportServer != null) {
            this.transportServer.stop();
            this.transportServer.dispose();
            this.transportServer = null;
        }
        log.info((Object)"Stopped transport loader");
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception e) {
            log.error((Object)"Failed to shutdown", (Throwable)e);
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(TransportLoader.class);
        infoFactory.addAttribute("clientConnectURI", URI.class, false);
        infoFactory.addAttribute("bindURI", URI.class, true);
        infoFactory.addReference("Router", Router.class);
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

