/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.remoting.transport;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.geronimo.core.service.Invocation;
import org.apache.geronimo.core.service.InvocationResult;
import org.apache.geronimo.core.service.SimpleInvocationResult;
import org.apache.geronimo.remoting.InvocationSupport;
import org.apache.geronimo.remoting.InvocationType;
import org.apache.geronimo.remoting.MarshalledObject;
import org.apache.geronimo.remoting.TransportInterceptor;
import org.apache.geronimo.remoting.transport.Msg;
import org.apache.geronimo.remoting.transport.TransportClient;
import org.apache.geronimo.remoting.transport.TransportFactory;

public class RemoteTransportInterceptor
implements TransportInterceptor,
Externalizable {
    URI remoteURI;
    transient TransportClient transportClient;

    public RemoteTransportInterceptor() {
    }

    public RemoteTransportInterceptor(URI remoteURI) {
        this.remoteURI = remoteURI;
    }

    public InvocationResult invoke(Invocation invocation) throws Throwable {
        MarshalledObject mo = InvocationSupport.getMarshaledValue(invocation);
        InvocationType type = InvocationSupport.getInvocationType(invocation);
        if (type == null) {
            type = InvocationType.REQUEST;
        }
        Msg msg = this.transportClient.createMsg();
        msg.pushMarshaledObject(mo);
        if (type == InvocationType.REQUEST) {
            msg = this.transportClient.sendRequest(this.remoteURI, msg);
            return new SimpleInvocationResult(true, (Object)msg.popMarshaledObject());
        }
        this.transportClient.sendDatagram(this.remoteURI, msg);
        MarshalledObject rcmo = this.transportClient.createMarshalledObject();
        rcmo.set(null);
        return new SimpleInvocationResult(true, (Object)rcmo);
    }

    public MarshalledObject createMarshalledObject() {
        return this.transportClient.createMarshalledObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.remoteURI.toString());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            this.remoteURI = new URI(in.readUTF());
            TransportFactory tf = TransportFactory.getTransportFactory(this.remoteURI);
            this.transportClient = tf.createClient();
        }
        catch (URISyntaxException e) {
            throw new StreamCorruptedException(e.getMessage());
        }
    }

    public URI getRemoteURI() {
        return this.remoteURI;
    }

    public void setRemoteURI(URI remoteURI) {
        this.remoteURI = remoteURI;
        TransportFactory tf = TransportFactory.getTransportFactory(remoteURI);
        this.transportClient = tf.createClient();
    }
}

