/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.remoting.transport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.lang.reflect.Proxy;
import org.apache.geronimo.kernel.ClassLoading;
import org.apache.geronimo.remoting.MarshalledObject;
import org.apache.geronimo.remoting.TransportContext;

public class BytesMarshalledObject
implements MarshalledObject,
Externalizable {
    private byte[] data;
    private TransportContext transportContext;

    public BytesMarshalledObject() {
    }

    public BytesMarshalledObject(Object value) throws IOException {
        this.set(value);
    }

    public BytesMarshalledObject(TransportContext transportContext) {
        this.transportContext = transportContext;
    }

    public BytesMarshalledObject(TransportContext transportContext, Object value) throws IOException {
        this.transportContext = transportContext;
        this.set(value);
    }

    public void set(Object value) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStreamExt os = new ObjectOutputStreamExt(baos, this.transportContext);
        os.writeObject(value);
        os.close();
        this.data = baos.toByteArray();
    }

    public byte[] getBytes() {
        return this.data;
    }

    public void setBytes(byte[] data) {
        this.data = data;
    }

    public Object get() throws IOException, ClassNotFoundException {
        return this.get(Thread.currentThread().getContextClassLoader());
    }

    public Object get(ClassLoader classloader) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(this.data);
        ObjectInputStreamExt is = new ObjectInputStreamExt(bais, classloader, this.transportContext);
        Object rc = is.readObject();
        is.close();
        return rc;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.data.length);
        out.write(this.data);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        this.data = new byte[size];
        in.readFully(this.data);
    }

    static class ObjectOutputStreamExt
    extends ObjectOutputStream {
        private TransportContext transportContext;

        public ObjectOutputStreamExt(OutputStream out, TransportContext transportContext) throws IOException {
            super(out);
            this.transportContext = transportContext;
            this.enableReplaceObject(transportContext != null);
        }

        protected Object replaceObject(Object obj) throws IOException {
            return this.transportContext.writeReplace(obj);
        }
    }

    public class ObjectInputStreamExt
    extends ObjectInputStream {
        private ClassLoader classloader;
        private TransportContext transportContext;

        public ObjectInputStreamExt(InputStream in, ClassLoader loader, TransportContext transportContext) throws IOException {
            super(in);
            this.transportContext = transportContext;
            this.classloader = loader;
            this.enableResolveObject(transportContext != null);
        }

        protected Class resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
            return ClassLoading.loadClass((String)classDesc.getName(), (ClassLoader)this.classloader);
        }

        protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
            Class[] cinterfaces = new Class[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                cinterfaces[i] = this.classloader.loadClass(interfaces[i]);
            }
            try {
                return Proxy.getProxyClass(this.classloader, cinterfaces);
            }
            catch (IllegalArgumentException e) {
                throw new ClassNotFoundException(null, e);
            }
        }

        protected Object resolveObject(Object obj) throws IOException {
            return this.transportContext.readReplace(obj);
        }
    }
}

