/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.remoting.router;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.remoting.router.AbstractInterceptorRouter;
import org.apache.geronimo.remoting.router.AbstractRouterRouter;
import org.apache.geronimo.remoting.router.Router;

public class SubsystemRouter
extends AbstractRouterRouter {
    Log log = LogFactory.getLog((Class)SubsystemRouter.class);
    Map currentRoutingMap = new HashMap();
    Collection childRouters;
    public static final GBeanInfo GBEAN_INFO;

    protected Router lookupRouterFrom(URI to) {
        String subsystem = to.getPath();
        return (Router)this.currentRoutingMap.get(subsystem);
    }

    public synchronized void addRoute(String path, Router router) {
        HashMap<String, Router> temp = new HashMap<String, Router>(this.currentRoutingMap);
        temp.put(path, router);
        this.currentRoutingMap = temp;
    }

    public synchronized void removeRoute(String path) {
        HashMap temp = new HashMap(this.currentRoutingMap);
        temp.remove(path);
        this.currentRoutingMap = temp;
    }

    public Router getRouter() {
        return this;
    }

    public void doStart() {
        super.doStart();
        this.log.info((Object)"Started subsystem router");
    }

    public void doStop() {
        super.doStop();
        this.log.info((Object)"Stopped subsystem router");
    }

    public void doFail() {
        super.doFail();
        this.log.info((Object)"Failed subsystem router");
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(SubsystemRouter.class, AbstractInterceptorRouter.GBEAN_INFO);
        infoFactory.addOperation("addRoute", new Class[]{String.class, Router.class});
        infoFactory.addOperation("removeRoute", new Class[]{String.class});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

