/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.remoting.router;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.core.service.Interceptor;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.remoting.router.AbstractInterceptorRouter;
import org.apache.geronimo.remoting.router.JMXTarget;
import org.apache.geronimo.remoting.router.SubsystemRouter;

public class JMXRouter
extends AbstractInterceptorRouter {
    private static final Log log = LogFactory.getLog((Class)JMXRouter.class);
    private SubsystemRouter subsystemRouter;
    private Map registered = new HashMap();
    public static final GBeanInfo GBEAN_INFO;

    public SubsystemRouter getSubsystemRouter() {
        return this.subsystemRouter;
    }

    public void setSubsystemRouter(SubsystemRouter subsystemRouter) {
        this.subsystemRouter = subsystemRouter;
    }

    public void register(ObjectName objectName, JMXTarget target) {
        this.registered.put(objectName, target);
    }

    public void unregister(ObjectName objectName) {
        this.registered.remove(objectName);
    }

    protected Interceptor lookupInterceptorFrom(URI to) throws Exception {
        ObjectName objectName = new ObjectName(to.getFragment());
        JMXTarget bean = (JMXTarget)this.registered.get(objectName);
        if (bean != null) {
            return bean.getRemotingEndpointInterceptor();
        }
        throw new IllegalArgumentException("No names mbeans registered that match object name pattern: " + objectName);
    }

    public void doStart() {
        this.subsystemRouter.addRoute("/JMX", this);
        super.doStart();
        log.info((Object)"Started JMX Router");
    }

    public void doStop() {
        super.doStop();
        this.subsystemRouter.removeRoute("/JMX");
        log.info((Object)"Stopped JMX Router");
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(JMXRouter.class, AbstractInterceptorRouter.GBEAN_INFO);
        infoFactory.addReference("SubsystemRouter", SubsystemRouter.class);
        infoFactory.addOperation("register", new Class[]{ObjectName.class, JMXTarget.class});
        infoFactory.addOperation("unregister", new Class[]{ObjectName.class});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

