/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.remoting.router;

import EDU.oswego.cs.dl.util.concurrent.Latch;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import EDU.oswego.cs.dl.util.concurrent.TimeoutSync;
import java.net.URI;
import org.apache.geronimo.core.service.Interceptor;
import org.apache.geronimo.core.service.Invocation;
import org.apache.geronimo.core.service.InvocationResult;
import org.apache.geronimo.core.service.SimpleInvocation;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.remoting.InvocationSupport;
import org.apache.geronimo.remoting.MarshalledObject;
import org.apache.geronimo.remoting.router.Router;
import org.apache.geronimo.remoting.transport.Msg;
import org.apache.geronimo.remoting.transport.TransportException;

public abstract class AbstractInterceptorRouter
implements GBeanLifecycle,
Router {
    private long stoppedRoutingTimeout = 60000L;
    private Sync routerLock = this.createNewRouterLock();
    public static final GBeanInfo GBEAN_INFO;

    public long getStoppedRoutingTimeout() {
        return this.stoppedRoutingTimeout;
    }

    public void setStoppedRoutingTimeout(long stoppedRoutingTimeout) {
        this.stoppedRoutingTimeout = stoppedRoutingTimeout;
    }

    private Sync createNewRouterLock() {
        Latch lock = new Latch();
        return new TimeoutSync((Sync)lock, this.stoppedRoutingTimeout);
    }

    public Msg sendRequest(URI to, Msg msg) throws TransportException {
        try {
            this.routerLock.acquire();
            Interceptor interceptor = this.lookupInterceptorFrom(to);
            SimpleInvocation invocation = new SimpleInvocation();
            InvocationSupport.putMarshaledValue((Invocation)invocation, msg.popMarshaledObject());
            InvocationSupport.putRemoteURI((Invocation)invocation, to);
            InvocationResult result = interceptor.invoke((Invocation)invocation);
            msg = msg.createMsg();
            Object rc = result.getResult();
            msg.pushMarshaledObject((MarshalledObject)rc);
            return msg;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TransportException(e.getMessage());
        }
    }

    public void sendDatagram(URI to, Msg msg) throws TransportException {
        try {
            this.routerLock.acquire();
            Interceptor interceptor = this.lookupInterceptorFrom(to);
            SimpleInvocation invocation = new SimpleInvocation();
            InvocationSupport.putMarshaledValue((Invocation)invocation, msg.popMarshaledObject());
            InvocationSupport.putRemoteURI((Invocation)invocation, to);
            interceptor.invoke((Invocation)invocation);
        }
        catch (Throwable e) {
            throw new TransportException(e.getMessage());
        }
    }

    protected abstract Interceptor lookupInterceptorFrom(URI var1) throws Throwable;

    public void doStart() {
        this.routerLock.release();
    }

    public void doStop() {
        this.routerLock = this.createNewRouterLock();
    }

    public void doFail() {
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(AbstractInterceptorRouter.class);
        infoFactory.addOperation("sendRequest", new Class[]{URI.class, Msg.class});
        infoFactory.addOperation("sendDatagram", new Class[]{URI.class, Msg.class});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

