/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.remoting.jmx;

import javax.management.ObjectName;
import org.apache.geronimo.core.service.Interceptor;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.jmx.JMXUtil;
import org.apache.geronimo.proxy.ProxyContainer;
import org.apache.geronimo.proxy.ReflexiveInterceptor;
import org.apache.geronimo.remoting.DeMarshalingInterceptor;
import org.apache.geronimo.remoting.router.JMXRouter;
import org.apache.geronimo.remoting.router.JMXTarget;

public class MBeanServerStub
implements GBeanLifecycle,
JMXTarget {
    private final Kernel kernel;
    private final ObjectName objectName;
    private ProxyContainer serverContainer;
    private DeMarshalingInterceptor demarshaller;
    private JMXRouter router;
    public static final GBeanInfo GBEAN_INFO;

    public MBeanServerStub(Kernel kernel, String objectName) {
        this.kernel = kernel;
        this.objectName = JMXUtil.getObjectName((String)objectName);
    }

    public Interceptor getRemotingEndpointInterceptor() {
        return this.demarshaller;
    }

    public JMXRouter getRouter() {
        return this.router;
    }

    public void setRouter(JMXRouter router) {
        this.router = router;
    }

    public void doStart() {
        this.router.register(this.objectName, this);
        ReflexiveInterceptor firstInterceptor = new ReflexiveInterceptor((Object)this.kernel.getMBeanServer());
        this.demarshaller = new DeMarshalingInterceptor((Interceptor)firstInterceptor, this.getClass().getClassLoader());
        this.serverContainer = new ProxyContainer((Interceptor)firstInterceptor);
    }

    public void doStop() {
        this.router.unregister(this.objectName);
        this.serverContainer = null;
        this.demarshaller = null;
    }

    public void doFail() {
        this.serverContainer = null;
        this.demarshaller = null;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(MBeanServerStub.class);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("objectName", String.class, false);
        infoFactory.addOperation("getRemotingEndpointInterceptor");
        infoFactory.addReference("Router", JMXRouter.class);
        infoFactory.setConstructor(new String[]{"kernel", "objectName"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

