/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.remoting;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.geronimo.core.service.Interceptor;
import org.apache.geronimo.core.service.Invocation;
import org.apache.geronimo.core.service.InvocationResult;
import org.apache.geronimo.remoting.DeMarshalingInterceptor;
import org.apache.geronimo.remoting.InterceptorRegistry;
import org.apache.geronimo.remoting.InvocationSupport;
import org.apache.geronimo.remoting.MarshalingInterceptor;
import org.apache.geronimo.remoting.transport.NullTransportInterceptor;

public class IntraVMRoutingInterceptor
implements Interceptor,
Externalizable {
    Long deMarshalingInterceptorID;
    boolean allwaysMarshall = false;
    transient Interceptor next;

    public IntraVMRoutingInterceptor(Interceptor next, Long deMarshalingInterceptorID, boolean allwaysMarshall) {
        this.next = next;
        this.deMarshalingInterceptorID = deMarshalingInterceptorID;
        this.allwaysMarshall = allwaysMarshall;
    }

    public IntraVMRoutingInterceptor() {
    }

    public IntraVMRoutingInterceptor(Long deMarshalingInterceptorID, boolean allwaysMarshall) {
        this.deMarshalingInterceptorID = deMarshalingInterceptorID;
        this.allwaysMarshall = allwaysMarshall;
    }

    public InvocationResult invoke(Invocation invocation) throws Throwable {
        return this.next.invoke(invocation);
    }

    private synchronized void resolveNext() {
        ClassLoader child;
        DeMarshalingInterceptor deMarshalingInterceptor = (DeMarshalingInterceptor)InterceptorRegistry.instance.lookup(this.deMarshalingInterceptorID);
        if (deMarshalingInterceptor == null) {
            return;
        }
        ClassLoader parent = deMarshalingInterceptor.getClassloader();
        this.next = InvocationSupport.isAncestor(parent, child = Thread.currentThread().getContextClassLoader()) && !this.allwaysMarshall ? deMarshalingInterceptor.getNext() : new MarshalingInterceptor(new NullTransportInterceptor(deMarshalingInterceptor));
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.deMarshalingInterceptorID);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deMarshalingInterceptorID = new Long(in.readLong());
        this.resolveNext();
    }

    public Long getDeMarshalingInterceptorID() {
        return this.deMarshalingInterceptorID;
    }

    public void setDeMarshalingInterceptorID(Long deMarshalingInterceptorID) {
        this.deMarshalingInterceptorID = deMarshalingInterceptorID;
    }

    public boolean getAlwaysMarshall() {
        return this.allwaysMarshall;
    }

    public void setAlwaysMarshall(boolean value) {
        this.allwaysMarshall = value;
    }
}

