/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.remoting;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.geronimo.core.service.Interceptor;
import org.apache.geronimo.core.service.Invocation;
import org.apache.geronimo.core.service.InvocationResult;
import org.apache.geronimo.remoting.MarshalingInterceptor;
import org.apache.geronimo.remoting.TransportInterceptor;

public class InterVMRoutingInterceptor
implements Interceptor,
Externalizable {
    String targetVMID = InterVMRoutingInterceptor.getLocalVMID();
    transient Interceptor next;
    TransportInterceptor transportInterceptor;
    Interceptor localInterceptor;
    static final String localVMID = "VM:" + System.currentTimeMillis();

    public InterVMRoutingInterceptor() {
    }

    public InterVMRoutingInterceptor(Interceptor transportInterceptor, Interceptor localInterceptor) {
        this.transportInterceptor = (TransportInterceptor)transportInterceptor;
        this.localInterceptor = localInterceptor;
        this.next = localInterceptor;
    }

    public InvocationResult invoke(Invocation invocation) throws Throwable {
        return this.next.invoke(invocation);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.targetVMID);
        out.writeObject(this.transportInterceptor);
        out.writeObject(this.localInterceptor);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.targetVMID = in.readUTF();
        this.transportInterceptor = (TransportInterceptor)in.readObject();
        this.localInterceptor = (Interceptor)in.readObject();
        this.next = InterVMRoutingInterceptor.getLocalVMID().equals(this.targetVMID) ? this.localInterceptor : new MarshalingInterceptor(this.transportInterceptor);
    }

    public static String getLocalVMID() {
        return localVMID;
    }

    public Interceptor getLocalInterceptor() {
        return this.localInterceptor;
    }

    public void setLocalInterceptor(Interceptor localInterceptor) {
        this.localInterceptor = localInterceptor;
    }

    public TransportInterceptor getTransportInterceptor() {
        return this.transportInterceptor;
    }

    public void setTransportInterceptor(TransportInterceptor remotingInterceptor) {
        this.transportInterceptor = remotingInterceptor;
    }

    public String getTargetVMID() {
        return this.targetVMID;
    }

    public void setTargetVMID(String targetVMID) {
        this.targetVMID = targetVMID;
    }
}

