/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.remoting;

import java.io.Serializable;
import org.apache.geronimo.core.service.Interceptor;
import org.apache.geronimo.core.service.Invocation;
import org.apache.geronimo.core.service.InvocationResult;
import org.apache.geronimo.core.service.SimpleInvocationResult;
import org.apache.geronimo.remoting.InvocationSupport;
import org.apache.geronimo.remoting.MarshalledObject;

public class DeMarshalingInterceptor
implements Interceptor {
    private ClassLoader classloader;
    private Interceptor next;

    public DeMarshalingInterceptor(Interceptor next) {
        this.next = next;
    }

    public DeMarshalingInterceptor(Interceptor next, ClassLoader classloader) {
        this.next = next;
        this.classloader = classloader;
    }

    public ClassLoader getClassloader() {
        return this.classloader;
    }

    public void setClassloader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvocationResult invoke(Invocation invocation) throws Throwable {
        Thread currentThread = Thread.currentThread();
        ClassLoader orig = currentThread.getContextClassLoader();
        try {
            Invocation marshalledInvocation;
            MarshalledObject mo = InvocationSupport.getMarshaledValue(invocation);
            try {
                currentThread.setContextClassLoader(this.classloader);
                marshalledInvocation = (Invocation)mo.get();
            }
            catch (Throwable e) {
                mo.set(new ThrowableWrapper(e));
                SimpleInvocationResult simpleInvocationResult = new SimpleInvocationResult(false, (Object)mo);
                currentThread.setContextClassLoader(orig);
                return simpleInvocationResult;
            }
            InvocationResult rc = this.next.invoke(marshalledInvocation);
            mo.set(new SimpleInvocationResult(rc.isNormal(), rc.getResult()));
            SimpleInvocationResult simpleInvocationResult = new SimpleInvocationResult(true, (Object)mo);
            return simpleInvocationResult;
        }
        finally {
            currentThread.setContextClassLoader(orig);
        }
    }

    public Interceptor getNext() {
        return this.next;
    }

    public static class ThrowableWrapper
    implements Serializable {
        public Throwable exception;

        ThrowableWrapper(Throwable exception) {
            this.exception = exception;
        }
    }
}

