/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.remoting.transport.async;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.io.IOException;
import java.net.URI;
import java.rmi.Remote;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.core.service.Interceptor;
import org.apache.geronimo.proxy.ProxyContainer;
import org.apache.geronimo.proxy.ReflexiveInterceptor;
import org.apache.geronimo.remoting.DeMarshalingInterceptor;
import org.apache.geronimo.remoting.InterceptorRegistry;
import org.apache.geronimo.remoting.MarshalingInterceptor;
import org.apache.geronimo.remoting.TransportContext;
import org.apache.geronimo.remoting.router.InterceptorRegistryRouter;
import org.apache.geronimo.remoting.router.SubsystemRouter;
import org.apache.geronimo.remoting.transport.RemoteTransportInterceptor;
import org.apache.geronimo.remoting.transport.URISupport;
import org.apache.geronimo.remoting.transport.async.AbstractServer;
import org.apache.geronimo.remoting.transport.async.BackChannelServer;
import org.apache.geronimo.remoting.transport.async.IdentityInterceptor;
import org.apache.geronimo.remoting.transport.async.RemoteRef;
import org.apache.geronimo.remoting.transport.async.TransportFactory;

public class Registry {
    public static final long REQUEST_TIMEOUT = Long.parseLong(System.getProperty("org.apache.geronimo.remoting.transport.async.request_timeout", "60000"));
    public static final int MAX_CONNECTION_POOL_SIZE = Integer.parseInt(System.getProperty("org.apache.geronimo.remoting.transport.async.max_connection_per_pool", "25"));
    private static final Log log = LogFactory.getLog((Class)Registry.class);
    public static final Registry instance = new Registry();
    private AbstractServer dynamicServer;
    private AbstractServer defaultServer;
    private PooledExecutor workManager;
    protected ClockDaemon clockDaemon;
    public boolean MOCK_APPLET_SECURITY = false;
    private int nextWorkerID = 0;
    Map exportedObjects = Collections.synchronizedMap(new HashMap());
    Map importedObjects = new WeakHashMap();
    public static final TransportContext transportContext = new TransportContext(){

        public Object writeReplace(Object proxy) throws IOException {
            if (proxy instanceof Remote) {
                return instance.exportObject(proxy);
            }
            return proxy;
        }

        public Object readReplace(Object obj) throws IOException {
            if (obj instanceof RemoteRef) {
                return instance.importObject((RemoteRef)obj);
            }
            return obj;
        }
    };

    private int getNextWorkerID() {
        return this.nextWorkerID++;
    }

    public synchronized Executor getWorkManager() {
        if (this.workManager != null) {
            return this.workManager;
        }
        PooledExecutor p = new PooledExecutor();
        p.setKeepAliveTime(30000L);
        p.setMinimumPoolSize(5);
        p.setMaximumPoolSize(Integer.MAX_VALUE);
        p.setThreadFactory(new ThreadFactory(){

            public Thread newThread(Runnable arg0) {
                return new Thread(arg0, "Remoting 'async' protocol worker " + Registry.this.getNextWorkerID());
            }
        });
        this.workManager = p;
        return this.workManager;
    }

    public ClockDaemon getClockDaemon() {
        if (this.clockDaemon != null) {
            return this.clockDaemon;
        }
        this.clockDaemon = new ClockDaemon();
        this.clockDaemon.setThreadFactory(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "Remoting 'async' protocol monitor");
                t.setDaemon(true);
                return t;
            }
        });
        return this.clockDaemon;
    }

    public synchronized AbstractServer getServerForClientRequest() {
        if (this.defaultServer != null) {
            return this.defaultServer;
        }
        if (this.dynamicServer != null) {
            return this.dynamicServer;
        }
        try {
            if (this.MOCK_APPLET_SECURITY) {
                this.dynamicServer = this.createBackChannelServer();
                return this.dynamicServer;
            }
            this.dynamicServer = (AbstractServer)TransportFactory.instance.createSever();
            SubsystemRouter subsystemRouter = new SubsystemRouter();
            subsystemRouter.doStart();
            InterceptorRegistryRouter registryRouter = new InterceptorRegistryRouter();
            registryRouter.setSubsystemRouter(subsystemRouter);
            registryRouter.doStart();
            this.dynamicServer.bind(new URI("async://0.0.0.0:0"), subsystemRouter);
            this.dynamicServer.start();
            return this.dynamicServer;
        }
        catch (Throwable e) {
            this.dynamicServer = this.createBackChannelServer();
            return this.dynamicServer;
        }
    }

    private AbstractServer createBackChannelServer() {
        try {
            BackChannelServer server = new BackChannelServer();
            server.bind(new URI("async://0.0.0.0:0"), null);
            server.start();
            return server;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public synchronized void setDefaultServer(AbstractServer server) {
        this.defaultServer = server;
    }

    public synchronized AbstractServer getDefaultServer() {
        return this.defaultServer;
    }

    public RemoteRef exportObject(Object object) throws IOException {
        ObjectKey key = new ObjectKey(object);
        ExportedObject eo = (ExportedObject)this.exportedObjects.get(key);
        if (eo == null) {
            eo = new ExportedObject();
            ReflexiveInterceptor ri = new ReflexiveInterceptor(object);
            DeMarshalingInterceptor demarshaller = new DeMarshalingInterceptor((Interceptor)ri, object.getClass().getClassLoader());
            Long dmiid = InterceptorRegistry.instance.register(demarshaller);
            eo.serverContainer = new ProxyContainer((Interceptor)demarshaller);
            eo.remoteRef = new RemoteRef();
            try {
                AbstractServer server = this.getServerForClientRequest();
                URI uri = server.getClientConnectURI();
                uri = URISupport.setPath(uri, "/Remoting");
                eo.remoteRef.remoteURI = uri = URISupport.setFragment(uri, "" + dmiid);
            }
            catch (Exception e) {
                throw new IOException("Remote URI could not be constructed.");
            }
            eo.remoteRef.interfaces = object.getClass().getInterfaces();
            this.exportedObjects.put(key, eo);
            log.debug((Object)("Exported object: " + eo.remoteRef.remoteURI));
        }
        return eo.remoteRef;
    }

    public boolean unexportObject(Object object) {
        ObjectKey key = new ObjectKey(object);
        return this.exportedObjects.remove(key) != null;
    }

    protected synchronized Object importObject(RemoteRef ref) {
        Object object = this.importedObjects.get(ref);
        if (object == null) {
            RemoteTransportInterceptor transport = new RemoteTransportInterceptor(ref.remoteURI);
            MarshalingInterceptor mashaller = new MarshalingInterceptor(transport);
            IdentityInterceptor identity = new IdentityInterceptor(mashaller, ref);
            ProxyContainer clientContainer = new ProxyContainer((Interceptor)identity);
            object = clientContainer.createProxy(Thread.currentThread().getContextClassLoader(), ref.interfaces);
            log.trace((Object)("Imported object: " + ref.remoteURI));
            this.importedObjects.put(ref, object);
        }
        return object;
    }

    static class ExportedObject {
        RemoteRef remoteRef;
        ProxyContainer serverContainer;

        ExportedObject() {
        }
    }

    static class ObjectKey {
        private Object key;

        ObjectKey(Object key) {
            this.key = key;
        }

        public boolean equals(Object obj) {
            return ((ObjectKey)obj).key == this.key;
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }
}

