/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.remoting.transport.async;

import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Compression {
    private static final Log log = LogFactory.getLog((Class)Compression.class);

    public static byte[] compress(byte[] input, int compressionLevel) {
        Deflater deflater = new Deflater(compressionLevel);
        deflater.setInput(input, 0, input.length);
        deflater.finish();
        byte[] buff = new byte[input.length + 50];
        int wsize = deflater.deflate(buff);
        int compressedSize = deflater.getTotalOut();
        if (deflater.getTotalIn() != input.length) {
            return null;
        }
        if (compressedSize >= input.length - 4) {
            return null;
        }
        byte[] output = new byte[compressedSize + 4];
        System.arraycopy(buff, 0, output, 4, compressedSize);
        output[0] = (byte)(input.length >> 24);
        output[1] = (byte)(input.length >> 16);
        output[2] = (byte)(input.length >> 8);
        output[3] = (byte)input.length;
        return output;
    }

    public static byte[] uncompress(byte[] input) throws IOException {
        try {
            int uncompressedSize = ((input[0] & 0xFF) << 24) + ((input[1] & 0xFF) << 16) + ((input[2] & 0xFF) << 8) + (input[3] & 0xFF);
            Inflater inflater = new Inflater();
            inflater.setInput(input, 4, input.length - 4);
            inflater.finished();
            byte[] out = new byte[uncompressedSize];
            inflater.inflate(out);
            inflater.reset();
            return out;
        }
        catch (DataFormatException e) {
            throw new IOException("Input Stream is corrupt: " + e);
        }
    }
}

