/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.remoting.transport;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.geronimo.remoting.transport.TransportClient;
import org.apache.geronimo.remoting.transport.TransportServer;

public abstract class TransportFactory {
    private static ArrayList factories = new ArrayList();

    private static TransportFactory loadFactory(String type) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String className = "org.apache.geronimo.remoting.transport." + type + ".TransportFactory";
        return (TransportFactory)Thread.currentThread().getContextClassLoader().loadClass(className).newInstance();
    }

    public static TransportFactory getTransportFactory(URI uri) {
        Iterator iterator = factories.iterator();
        while (iterator.hasNext()) {
            TransportFactory i = (TransportFactory)iterator.next();
            if (!i.handles(uri)) continue;
            return i;
        }
        try {
            TransportFactory factory = TransportFactory.loadFactory(uri.getScheme());
            if (factory.handles(uri)) {
                TransportFactory.addFactory(factory);
                return factory;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static boolean unexport(Object object) {
        boolean wasExported = false;
        Iterator iterator = factories.iterator();
        while (iterator.hasNext()) {
            TransportFactory i = (TransportFactory)iterator.next();
            if (!i.doUnexport(object)) continue;
            wasExported = true;
        }
        return wasExported;
    }

    public static void addFactory(TransportFactory tf) {
        factories.add(tf);
    }

    public static void removeFactory(TransportFactory tf) {
        factories.remove(tf);
    }

    protected abstract boolean handles(URI var1);

    public abstract TransportClient createClient();

    public abstract TransportServer createSever();

    public abstract boolean doUnexport(Object var1);

    static {
        try {
            TransportFactory.addFactory(TransportFactory.loadFactory("async"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

