/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.remoting.transport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.geronimo.remoting.MarshalledObject;
import org.apache.geronimo.remoting.TransportContext;
import org.apache.geronimo.remoting.transport.BytesMarshalledObject;
import org.apache.geronimo.remoting.transport.Msg;

public class BytesMsg
implements Msg {
    transient TransportContext transportContext;
    ArrayList objectStack = new ArrayList(5);

    public BytesMsg(TransportContext transportContext) {
        this.transportContext = transportContext;
    }

    public void pushMarshaledObject(MarshalledObject mo) throws IOException {
        this.objectStack.add((BytesMarshalledObject)mo);
    }

    public MarshalledObject popMarshaledObject() throws IOException {
        if (this.objectStack.size() == 0) {
            throw new ArrayIndexOutOfBoundsException("Object stack is empty.");
        }
        return (MarshalledObject)this.objectStack.remove(this.objectStack.size() - 1);
    }

    public int getStackSize() {
        return this.objectStack.size();
    }

    public Msg createMsg() {
        return new BytesMsg(this.transportContext);
    }

    public void writeExternal(DataOutput out) throws IOException {
        out.writeByte(this.objectStack.size());
        for (int i = 0; i < this.objectStack.size(); ++i) {
            BytesMarshalledObject mo = (BytesMarshalledObject)this.objectStack.get(i);
            byte[] bs = mo.getBytes();
            out.writeInt(bs.length);
            out.write(bs);
        }
    }

    public void readExternal(DataInput in) throws IOException {
        this.objectStack.clear();
        int s = in.readByte();
        for (int i = 0; i < s; ++i) {
            int l = in.readInt();
            byte[] t = new byte[l];
            in.readFully(t);
            BytesMarshalledObject mo = new BytesMarshalledObject(this.transportContext);
            mo.setBytes(t);
            this.objectStack.add(mo);
        }
    }

    public byte[] getAsBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        this.writeExternal(os);
        os.close();
        return baos.toByteArray();
    }

    public void setFromBytes(byte[] data) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        DataInputStream is = new DataInputStream(bais);
        this.readExternal(is);
    }
}

