/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.remoting.router;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.geronimo.core.service.Interceptor;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.GOperationInfo;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.remoting.router.AbstractInterceptorRouter;
import org.apache.geronimo.remoting.router.JMXTarget;
import org.apache.geronimo.remoting.router.SubsystemRouter;

public class JMXRouter
extends AbstractInterceptorRouter {
    private SubsystemRouter subsystemRouter;
    private Map registered = new HashMap();
    public static final GBeanInfo GBEAN_INFO;

    public SubsystemRouter getSubsystemRouter() {
        return this.subsystemRouter;
    }

    public void setSubsystemRouter(SubsystemRouter subsystemRouter) {
        this.subsystemRouter = subsystemRouter;
    }

    public void register(ObjectName objectName, JMXTarget target) {
        this.registered.put(objectName, target);
    }

    public void unRegister(ObjectName objectName) {
        this.registered.remove(objectName);
    }

    protected Interceptor lookupInterceptorFrom(URI to) throws Exception {
        ObjectName objectName = new ObjectName(to.getFragment());
        JMXTarget bean = (JMXTarget)this.registered.get(objectName);
        if (bean != null) {
            return bean.getRemotingEndpointInterceptor();
        }
        throw new IllegalArgumentException("No names mbeans registered that match object name pattern: " + objectName);
    }

    public void doStart() {
        this.subsystemRouter.addRoute("/JMX", this);
        super.doStart();
    }

    public void doStop() {
        super.doStop();
        this.subsystemRouter.removeRoute("/JMX");
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoFactory infoFactory = new GBeanInfoFactory(JMXRouter.class.getName(), AbstractInterceptorRouter.GBEAN_INFO);
        infoFactory.addReference(new GReferenceInfo("SubsystemRouter", SubsystemRouter.class.getName()));
        infoFactory.addOperation(new GOperationInfo("register", new String[]{ObjectName.class.getName(), JMXTarget.class.getName()}));
        infoFactory.addOperation(new GOperationInfo("unRegister", new String[]{ObjectName.class.getName()}));
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

