/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.remoting.router;

import EDU.oswego.cs.dl.util.concurrent.Latch;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import EDU.oswego.cs.dl.util.concurrent.TimeoutSync;
import java.net.URI;
import org.apache.geronimo.gbean.GBean;
import org.apache.geronimo.gbean.GBeanContext;
import org.apache.geronimo.remoting.router.Router;
import org.apache.geronimo.remoting.transport.Msg;
import org.apache.geronimo.remoting.transport.TransportException;

public abstract class AbstractRouterRouter
implements GBean,
Router {
    private long stoppedRoutingTimeout = 60000L;
    private Sync routerLock = this.createNewRouterLock();

    public long getStoppedRoutingTimeout() {
        return this.stoppedRoutingTimeout;
    }

    public void setStoppedRoutingTimeout(long stoppedRoutingTimeout) {
        this.stoppedRoutingTimeout = stoppedRoutingTimeout;
    }

    private Sync createNewRouterLock() {
        Latch lock = new Latch();
        return new TimeoutSync((Sync)lock, this.stoppedRoutingTimeout);
    }

    public Msg sendRequest(URI to, Msg msg) throws TransportException {
        try {
            this.routerLock.acquire();
            Router next = this.lookupRouterFrom(to);
            if (next == null) {
                throw new TransportException("No route is available to: " + to);
            }
            return next.sendRequest(to, msg);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TransportException(e.getMessage());
        }
    }

    public void sendDatagram(URI to, Msg msg) throws TransportException {
        try {
            this.routerLock.acquire();
            Router next = this.lookupRouterFrom(to);
            next.sendDatagram(to, msg);
        }
        catch (Throwable e) {
            throw new TransportException(e.getMessage());
        }
    }

    protected abstract Router lookupRouterFrom(URI var1);

    public void setGBeanContext(GBeanContext context) {
    }

    public void doStart() {
        this.routerLock.release();
    }

    public void doStop() {
        this.routerLock = this.createNewRouterLock();
    }

    public void doFail() {
    }
}

