/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.remoting.jmx;

import java.net.URI;
import java.net.URISyntaxException;
import javax.management.MBeanServer;
import org.apache.geronimo.core.service.Interceptor;
import org.apache.geronimo.proxy.ProxyContainer;
import org.apache.geronimo.remoting.MarshalingInterceptor;
import org.apache.geronimo.remoting.jmx.NotificationRemoterInterceptor;
import org.apache.geronimo.remoting.transport.RemoteTransportInterceptor;

public class RemoteMBeanServerFactory {
    public static MBeanServer create(String host) throws IllegalArgumentException {
        return RemoteMBeanServerFactory.create(host, 3434);
    }

    public static MBeanServer create(String host, int port) throws IllegalArgumentException {
        URI target;
        try {
            target = new URI("async", null, host, port, "/JMX", null, "geronimo.remoting:target=MBeanServerStub");
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Bad host or port.");
        }
        return RemoteMBeanServerFactory.create(target);
    }

    public static MBeanServer create(URI target) {
        Interceptor firstInterceptor = new RemoteTransportInterceptor(target);
        firstInterceptor = new MarshalingInterceptor(firstInterceptor);
        firstInterceptor = new NotificationRemoterInterceptor(firstInterceptor);
        ProxyContainer clientContainer = new ProxyContainer(firstInterceptor);
        return (MBeanServer)clientContainer.createProxy(MBeanServer.class.getClassLoader(), new Class[]{MBeanServer.class});
    }

    private static RemoteMBeanServerFactory createRemoteMBeanServerFactory() {
        try {
            String factoryClass = System.getProperty("org.apache.geronimo.enterprise.deploy.server.RemoteMBeanServerFactory", "org.apache.geronimo.remoting.jmx.RemoteMBeanServerFactory");
            return (RemoteMBeanServerFactory)RemoteMBeanServerFactory.class.getClassLoader().loadClass(factoryClass).newInstance();
        }
        catch (Throwable e) {
            throw new RuntimeException("The RemoteMBeanServerFactory instance could not be loaded:", e);
        }
    }

    protected MBeanServer factoryCreate(String hostname) {
        return RemoteMBeanServerFactory.create(hostname);
    }
}

