/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.remoting;

import java.io.Serializable;
import org.apache.geronimo.core.service.Interceptor;
import org.apache.geronimo.core.service.Invocation;
import org.apache.geronimo.core.service.InvocationResult;
import org.apache.geronimo.remoting.DeMarshalingInterceptor;
import org.apache.geronimo.remoting.InvocationSupport;
import org.apache.geronimo.remoting.MarshalledObject;
import org.apache.geronimo.remoting.TransportInterceptor;

public class MarshalingInterceptor
implements Interceptor,
Serializable {
    TransportInterceptor next;

    public MarshalingInterceptor(Interceptor next) {
        this.next = (TransportInterceptor)next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvocationResult invoke(Invocation invocation) throws Throwable {
        ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
        try {
            Object obj;
            MarshalledObject mo = this.next.createMarshalledObject();
            mo.set(invocation);
            InvocationSupport.putMarshaledValue(invocation, mo);
            InvocationResult rc = this.next.invoke(invocation);
            mo = (MarshalledObject)rc.getResult();
            try {
                obj = mo.get();
            }
            catch (ClassNotFoundException e) {
                Thread.currentThread().setContextClassLoader(MarshalingInterceptor.class.getClassLoader());
                obj = mo.get();
            }
            if (obj instanceof DeMarshalingInterceptor.ThrowableWrapper) {
                throw ((DeMarshalingInterceptor.ThrowableWrapper)obj).exception;
            }
            InvocationResult invocationResult = (InvocationResult)obj;
            return invocationResult;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalLoader);
        }
    }
}

