/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.remoting;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.URI;
import org.apache.geronimo.core.service.Invocation;
import org.apache.geronimo.core.service.InvocationKey;
import org.apache.geronimo.remoting.InvocationType;
import org.apache.geronimo.remoting.MarshalledObject;

public final class InvocationSupport
implements Serializable,
InvocationKey {
    private static int MAX_ORDINAL;
    private static final InvocationSupport[] values;
    private static final InvocationSupport MARSAHLLED_VALUE;
    private static final InvocationSupport REMOTE_URI;
    private static final InvocationSupport INVOCATION_TYPE;
    private final transient String name;
    private final int ordinal;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static MarshalledObject getMarshaledValue(Invocation invocation) {
        return (MarshalledObject)invocation.get((InvocationKey)MARSAHLLED_VALUE);
    }

    public static void putMarshaledValue(Invocation invocation, MarshalledObject mo) {
        invocation.put((InvocationKey)MARSAHLLED_VALUE, (Object)mo);
    }

    public static URI getRemoteURI(Invocation invocation) {
        return (URI)invocation.get((InvocationKey)REMOTE_URI);
    }

    public static void putRemoteURI(Invocation invocation, URI remoteURI) {
        invocation.put((InvocationKey)REMOTE_URI, (Object)remoteURI);
    }

    public static InvocationType getInvocationType(Invocation invocation) {
        return (InvocationType)invocation.get((InvocationKey)INVOCATION_TYPE);
    }

    public static void putInvocationType(Invocation invocation, InvocationType type) {
        invocation.put((InvocationKey)INVOCATION_TYPE, (Object)type);
    }

    private InvocationSupport(String name, int ordinal) {
        if (!$assertionsDisabled && ordinal >= MAX_ORDINAL) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && values[ordinal] != null) {
            throw new AssertionError();
        }
        this.name = name;
        this.ordinal = ordinal;
        InvocationSupport.values[ordinal] = this;
    }

    public String toString() {
        return this.name;
    }

    Object readResolve() throws ObjectStreamException {
        return values[this.ordinal];
    }

    public static boolean isAncestor(ClassLoader parent, ClassLoader child) {
        if (child == null) {
            return parent == null;
        }
        if (parent == null) {
            return true;
        }
        while (child != null) {
            if (child.equals(parent)) {
                return true;
            }
            child = child.getParent();
        }
        return false;
    }

    public boolean isTransient() {
        return true;
    }

    static {
        $assertionsDisabled = !InvocationSupport.class.desiredAssertionStatus();
        MAX_ORDINAL = 3;
        values = new InvocationSupport[MAX_ORDINAL + 1];
        MARSAHLLED_VALUE = new InvocationSupport("MARSHALED_VALUE", 0);
        REMOTE_URI = new InvocationSupport("REMOTE_URI", 1);
        INVOCATION_TYPE = new InvocationSupport("INVOCATION_TYPE", 2);
    }
}

