/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.network.protocol.control.commands;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.geronimo.network.protocol.PacketField;
import org.apache.geronimo.network.protocol.PacketFieldFactory;
import org.apache.geronimo.network.protocol.ProtocolException;
import org.apache.geronimo.network.protocol.control.commands.CreateInstanceMenuItem;
import org.apache.geronimo.network.protocol.control.commands.SetAttributeMenuItem;
import org.apache.geronimo.network.protocol.control.commands.SetReferenceMenuItem;

public class MenuItemPacketFieldReader {
    private static MenuItemPacketFieldReader ourInstance = new MenuItemPacketFieldReader();
    protected Map factories = new HashMap();

    public static MenuItemPacketFieldReader getInstance() {
        return ourInstance;
    }

    public void register(byte key, PacketFieldFactory factory) {
        this.factories.put(new Byte(key), factory);
    }

    public PacketField read(ByteBuffer buffer) throws ProtocolException {
        Byte key = new Byte(buffer.get());
        PacketFieldFactory factory = (PacketFieldFactory)this.factories.get(key);
        if (factory == null) {
            throw new ProtocolException("No factory registered for " + key);
        }
        return factory.create(buffer);
    }

    private MenuItemPacketFieldReader() {
        this.register((byte)0, new CreateInstanceMenuItem());
        this.register((byte)1, new SetAttributeMenuItem());
        this.register((byte)2, new SetReferenceMenuItem());
    }
}

