/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.network.protocol.control;

import EDU.oswego.cs.dl.util.concurrent.Latch;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.network.SelectorManager;
import org.apache.geronimo.network.protocol.DownPacket;
import org.apache.geronimo.network.protocol.Protocol;
import org.apache.geronimo.network.protocol.ProtocolException;
import org.apache.geronimo.network.protocol.UpPacket;
import org.apache.geronimo.network.protocol.control.AbstractControlProtocol;
import org.apache.geronimo.network.protocol.control.BootRequestUpPacket;
import org.apache.geronimo.network.protocol.control.BootResponseDownPacket;
import org.apache.geronimo.network.protocol.control.BootSuccessUpPacket;
import org.apache.geronimo.network.protocol.control.BootstrapChef;
import org.apache.geronimo.network.protocol.control.ControlContext;
import org.apache.geronimo.network.protocol.control.ControlPacketReader;
import org.apache.geronimo.network.protocol.control.ControlServerListener;
import org.apache.geronimo.network.protocol.control.NoBootDownPacket;
import org.apache.geronimo.network.protocol.control.PassthroughDownPacket;
import org.apache.geronimo.network.protocol.control.PassthroughUpPacket;
import org.apache.geronimo.network.protocol.control.ShutdownRequestDownPacket;
import org.apache.geronimo.network.protocol.control.ShutdownRequestUpPacket;
import org.apache.geronimo.network.protocol.control.State;
import org.apache.geronimo.pool.ClockPool;
import org.apache.geronimo.pool.ThreadPool;

public class ControlServerProtocol
extends AbstractControlProtocol {
    private static final Log log = LogFactory.getLog((Class)ControlServerProtocol.class);
    private ControlServerListener controlServerListener;
    private BootstrapChef bootstrapChef;
    private ThreadPool threadPool;
    private ClockPool clockPool;
    private SelectorManager selectorManager;
    private long timeout;
    private final State START = new State(this){
        Latch startupLatch;
        {
            this.startupLatch = new Latch();
        }

        public void sendUp(UpPacket packet) throws ProtocolException {
            UpPacket p = ControlPacketReader.getInstance().read(packet.getBuffer());
            if (p instanceof BootRequestUpPacket) {
                log.trace((Object)"BOOT REQUEST");
                this.getDownProtocol().sendDown(ControlServerProtocol.this.constructBootPacket());
            } else if (p instanceof BootSuccessUpPacket) {
                log.trace((Object)"BOOT SUCCESS");
                log.trace((Object)("RELEASING " + this.startupLatch));
                ((ControlServerProtocol)this.getParent()).state = ControlServerProtocol.this.RUN;
                this.startupLatch.release();
                log.trace((Object)("RELEASED " + this.startupLatch));
            }
        }

        public void sendDown(DownPacket packet) throws ProtocolException {
            try {
                log.trace((Object)("AQUIRING " + this.startupLatch));
                if (!this.startupLatch.attempt(ControlServerProtocol.this.timeout)) {
                    throw new ProtocolException("Send timeout");
                }
                log.trace((Object)("AQUIRED " + this.startupLatch));
                PassthroughDownPacket passthtough = new PassthroughDownPacket();
                passthtough.setBuffers(packet.getBuffers());
                this.getDownProtocol().sendDown(passthtough);
            }
            catch (InterruptedException e) {
                throw new ProtocolException(e);
            }
        }
    };
    private final State RUN = new State(this){

        public void sendUp(UpPacket packet) throws ProtocolException {
            UpPacket p = ControlPacketReader.getInstance().read(packet.getBuffer());
            if (p instanceof PassthroughUpPacket) {
                log.trace((Object)"PASSTHROUGH");
                this.getUpProtocol().sendUp(packet);
            } else if (p instanceof ShutdownRequestUpPacket) {
                log.trace((Object)"SHUTDOWN_REQ");
                ((ControlServerProtocol)this.getParent()).state = ControlServerProtocol.this.START;
                ControlServerProtocol.this.controlServerListener.shutdown();
            }
        }

        public void sendDown(DownPacket packet) throws ProtocolException {
            PassthroughDownPacket passthtough = new PassthroughDownPacket();
            passthtough.setBuffers(packet.getBuffers());
            this.getDownProtocol().sendDown(passthtough);
        }
    };
    private volatile State state = this.START;

    public ControlServerListener getControlServerListener() {
        return this.controlServerListener;
    }

    public void setControlServerListener(ControlServerListener controlServerListener) {
        this.controlServerListener = controlServerListener;
    }

    public BootstrapChef getBootstrapChef() {
        return this.bootstrapChef;
    }

    public void setBootstrapChef(BootstrapChef bootstrapChef) {
        this.bootstrapChef = bootstrapChef;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public ClockPool getClockPool() {
        return this.clockPool;
    }

    public void setClockPool(ClockPool clockPool) {
        this.clockPool = clockPool;
    }

    public SelectorManager getSelectorManager() {
        return this.selectorManager;
    }

    public void setSelectorManager(SelectorManager selectorManager) {
        this.selectorManager = selectorManager;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public Protocol cloneProtocol() throws CloneNotSupportedException {
        ControlServerProtocol result = (ControlServerProtocol)super.clone();
        result.START.setParent(result);
        result.RUN.setParent(result);
        return result;
    }

    public void setup() throws ProtocolException {
        log.trace((Object)"Starting");
    }

    public void drain() throws ProtocolException {
        log.trace((Object)"Stopping");
        if (this.state == this.RUN) {
            this.getDownProtocol().sendDown(new ShutdownRequestDownPacket());
        }
    }

    public void teardown() throws ProtocolException {
    }

    public void sendUp(UpPacket packet) throws ProtocolException {
        this.state.sendUp(packet);
    }

    public void sendDown(DownPacket packet) throws ProtocolException {
        this.state.sendDown(packet);
    }

    public void flush() throws ProtocolException {
        this.getDownProtocol().flush();
    }

    protected DownPacket constructBootPacket() {
        ControlContext context = new ControlContext();
        context.setThreadPool(this.threadPool);
        context.setClockPool(this.clockPool);
        context.setSelectorManager(this.selectorManager);
        Collection menu = this.bootstrapChef.createMenu(context);
        if (menu == null) {
            return new NoBootDownPacket();
        }
        BootResponseDownPacket packet = new BootResponseDownPacket();
        packet.setMenu(menu);
        return packet;
    }
}

