/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.network.protocol.control;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.geronimo.network.SelectorManager;
import org.apache.geronimo.pool.ClockPool;
import org.apache.geronimo.pool.ThreadPool;

public class ControlContext {
    private ThreadPool threadPool;
    private ClockPool clockPool;
    private SelectorManager selectorManager;
    private ClassLoader classLoader;
    private Map assignments = new IdentityHashMap();
    private Map registrations = new HashMap();
    private long nextId = 3L;

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
        this.registrations.put(new Long(0L), threadPool);
        this.assignments.put(threadPool, new Long(0L));
    }

    public ClockPool getClockPool() {
        return this.clockPool;
    }

    public void setClockPool(ClockPool clockPool) {
        this.clockPool = clockPool;
        this.registrations.put(new Long(1L), clockPool);
        this.assignments.put(clockPool, new Long(1L));
    }

    public SelectorManager getSelectorManager() {
        return this.selectorManager;
    }

    public void setSelectorManager(SelectorManager selectorManager) {
        this.selectorManager = selectorManager;
        this.registrations.put(new Long(2L), selectorManager);
        this.assignments.put(selectorManager, new Long(2L));
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Long assignId(Object object) {
        if (this.threadPool == null) {
            throw new IllegalStateException("Thread pool not assigned");
        }
        if (this.clockPool == null) {
            throw new IllegalStateException("Clock pool not assigned");
        }
        if (this.selectorManager == null) {
            throw new IllegalStateException("Selector manager not assigned");
        }
        Long value = (Long)this.assignments.get(object);
        if (value == null) {
            value = new Long(this.nextId++);
            this.assignments.put(object, value);
        }
        return value;
    }

    public void register(Long id, Object object) {
        this.registrations.put(id, object);
    }

    public Object retrieve(Long id) {
        if (this.threadPool == null) {
            throw new IllegalStateException("Thread pool not assigned");
        }
        if (this.clockPool == null) {
            throw new IllegalStateException("Clock pool not assigned");
        }
        if (this.selectorManager == null) {
            throw new IllegalStateException("Selector manager not assigned");
        }
        return this.registrations.get(id);
    }
}

