/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.network.protocol.control;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.network.SelectorManager;
import org.apache.geronimo.network.protocol.Protocol;
import org.apache.geronimo.network.protocol.ProtocolException;
import org.apache.geronimo.network.protocol.ProtocolStack;
import org.apache.geronimo.network.protocol.control.ControlClientListener;
import org.apache.geronimo.network.protocol.control.ControlClientProtocol;
import org.apache.geronimo.network.protocol.control.ControlClientProtocolKitchen;
import org.apache.geronimo.network.protocol.control.ControlException;
import org.apache.geronimo.network.protocol.control.ControlServerProtocolStack;
import org.apache.geronimo.pool.ClockPool;
import org.apache.geronimo.pool.ThreadPool;

public class ControlClientProtocolStack
extends ProtocolStack
implements ControlClientListener {
    private static final Log log = LogFactory.getLog((Class)ControlServerProtocolStack.class);
    private ControlClientProtocolKitchen kitchen;
    private ClassLoader classLoader;
    private ThreadPool threadPool;
    private ClockPool clockPool;
    private SelectorManager selectorManager;

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public ClockPool getClockPool() {
        return this.clockPool;
    }

    public void setClockPool(ClockPool clockPool) {
        this.clockPool = clockPool;
    }

    public SelectorManager getSelectorManager() {
        return this.selectorManager;
    }

    public void setSelectorManager(SelectorManager selectorManager) {
        this.selectorManager = selectorManager;
    }

    public Object push(Object object) {
        if (object instanceof ControlClientProtocol) {
            ((ControlClientProtocol)object).setListener(this);
        }
        return super.push(object);
    }

    public Object pop() {
        Protocol result = (Protocol)super.pop();
        if (result instanceof ControlClientProtocol) {
            ((ControlClientProtocol)result).setListener(null);
        }
        return result;
    }

    public void setup() throws ProtocolException {
        try {
            this.kitchen = new ControlClientProtocolKitchen();
            this.kitchen.setClassLoader(this.classLoader);
            this.kitchen.setThreadPool(this.threadPool);
            this.kitchen.setClockPool(this.clockPool);
            this.kitchen.setSelectorManager(this.selectorManager);
            this.push(this.kitchen);
            super.setup();
        }
        catch (InterruptedException e) {
            throw new ProtocolException(e);
        }
    }

    public void drain() throws ProtocolException {
        this.pop();
        super.drain();
    }

    public void serveUp(Collection menu) throws ControlException {
        this.kitchen.serveUp(menu);
    }

    public void shutdown() {
        log.trace((Object)"Shutdown");
        try {
            this.drain();
        }
        catch (ProtocolException protocolException) {
            // empty catch block
        }
    }
}

