/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.network.protocol;

import EDU.oswego.cs.dl.util.concurrent.Mutex;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.network.SelectionEventListner;
import org.apache.geronimo.network.SelectorManager;
import org.apache.geronimo.network.protocol.AcceptableProtocol;
import org.apache.geronimo.network.protocol.DownPacket;
import org.apache.geronimo.network.protocol.Protocol;
import org.apache.geronimo.network.protocol.ProtocolException;
import org.apache.geronimo.network.protocol.UpPacket;

public class SocketProtocol
implements AcceptableProtocol,
SelectionEventListner {
    private Log log = LogFactory.getLog((Class)SocketProtocol.class);
    private Protocol up;
    private SocketChannel acceptedSocketChannel;
    private SocketChannel socketChannel;
    private SocketAddress address;
    private SocketAddress socketInterface;
    private long timeout;
    private boolean TCPNoDelay;
    private boolean reuseAddress = true;
    private Mutex sendMutex;
    private SelectorManager selectorManager;
    private SelectionKey selectionKey;
    private long created;
    private long lastUsed;
    private static final int STARTED = 0;
    private static final int STOPPED = 1;
    private int state = 1;
    ByteBuffer[] sendBuffer;
    ByteBuffer headerBuffer;
    ByteBuffer bodyBuffer;
    Object serviceReadMutex;
    Object serviceWriteMutex;
    static int nextConnectionId = 0;

    static synchronized int getNextConnectionId() {
        return nextConnectionId++;
    }

    public Protocol getUpProtocol() {
        return this.up;
    }

    public void setUpProtocol(Protocol up) {
        this.up = up;
    }

    public Protocol getDownProtocol() {
        throw new NoSuchMethodError("Socket protocol is at the bottom");
    }

    public void setDownProtocol(Protocol down) {
        throw new NoSuchMethodError("Socket protocol is at the bottom");
    }

    public void clearLinks() {
        this.up = null;
    }

    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    public void setSocketChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    public SocketAddress getAddress() {
        return this.address;
    }

    public void setAddress(SocketAddress address) {
        if (this.state == 0) {
            throw new IllegalStateException("Protocol already started");
        }
        this.address = address;
    }

    public SocketAddress getInterface() {
        return this.socketInterface;
    }

    public void setInterface(SocketAddress socketInterface) {
        if (this.state == 0) {
            throw new IllegalStateException("Protocol already started");
        }
        this.socketInterface = socketInterface;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        if (this.state == 0) {
            throw new IllegalStateException("Protocol already started");
        }
        this.timeout = timeout;
    }

    public boolean isTCPNoDelay() {
        return this.TCPNoDelay;
    }

    public void setTCPNoDelay(boolean TCPNoDelay) {
        if (this.state == 0) {
            throw new IllegalStateException("Protocol already started");
        }
        this.TCPNoDelay = TCPNoDelay;
    }

    public boolean isReuseAddress() {
        if (this.state == 0) {
            throw new IllegalStateException("Protocol already started");
        }
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public SelectorManager getSelectorManager() {
        return this.selectorManager;
    }

    public void setSelectorManager(SelectorManager selectorManager) {
        if (this.state == 0) {
            throw new IllegalStateException("Protocol already started");
        }
        this.selectorManager = selectorManager;
    }

    public boolean isDone() {
        return this.state == 1;
    }

    public long getCreated() {
        return this.created;
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    public Protocol cloneProtocol() throws CloneNotSupportedException {
        SocketProtocol p = (SocketProtocol)super.clone();
        p.log = LogFactory.getLog((String)(SocketProtocol.class.getName() + ":" + SocketProtocol.getNextConnectionId()));
        return p;
    }

    public void setup() throws ProtocolException {
        this.log = LogFactory.getLog((String)(SocketProtocol.class.getName() + ":" + SocketProtocol.getNextConnectionId()));
        this.sendMutex = new Mutex();
        this.headerBuffer = ByteBuffer.allocate(4);
        this.serviceReadMutex = new Object();
        this.serviceWriteMutex = new Object();
        if (this.address == null && this.acceptedSocketChannel == null) {
            throw new IllegalStateException("No address set");
        }
        this.log.trace((Object)("Starting " + this));
        if (this.acceptedSocketChannel == null) {
            try {
                this.socketChannel = SocketChannel.open();
                this.socketChannel.configureBlocking(true);
                this.socketChannel.socket().setReuseAddress(this.reuseAddress);
                this.socketChannel.socket().setTcpNoDelay(this.TCPNoDelay);
                if (this.socketInterface != null) {
                    this.socketChannel.socket().bind(this.socketInterface);
                }
                this.socketChannel.connect(this.address);
            }
            catch (SocketException e) {
                this.state = 1;
                throw new ProtocolException(e);
            }
            catch (IOException e) {
                this.state = 1;
                throw new ProtocolException(e);
            }
        } else {
            this.socketChannel = this.acceptedSocketChannel;
        }
        try {
            this.socketChannel.configureBlocking(false);
            this.selectionKey = this.selectorManager.register(this.socketChannel, 1, this);
            this.log.trace((Object)("+OP_READ " + this.selectionKey));
        }
        catch (ClosedChannelException e) {
            this.state = 1;
            throw new ProtocolException(e);
        }
        catch (IOException e) {
            this.state = 1;
            throw new ProtocolException(e);
        }
        this.created = System.currentTimeMillis();
        this.lastUsed = System.currentTimeMillis();
        this.state = 0;
    }

    public void drain() throws ProtocolException {
        this.log.trace((Object)"Stopping");
        this.close();
        this.state = 1;
    }

    public void teardown() throws ProtocolException {
    }

    public void sendUp(UpPacket packet) throws ProtocolException {
        throw new UnsupportedOperationException("Method not implemented");
    }

    public void sendDown(DownPacket packet) throws ProtocolException {
        if (this.state == 1) {
            throw new IllegalStateException("Protocol is not started");
        }
        this.lastUsed = System.currentTimeMillis();
        try {
            this.log.trace((Object)("AQUIRING " + this.sendMutex));
            if (!this.sendMutex.attempt(this.timeout)) {
                this.log.error((Object)("TIMEOUT " + this.sendMutex));
                throw new ProtocolException("Send timeout.");
            }
            this.log.trace((Object)("AQUIRED " + this.sendMutex));
            Collection patcketBuffers = packet.getBuffers();
            int n = patcketBuffers.size();
            this.sendBuffer = new ByteBuffer[n + 1];
            int size = 0;
            Iterator iter = patcketBuffers.iterator();
            int i = 1;
            while (iter.hasNext()) {
                this.sendBuffer[i] = (ByteBuffer)iter.next();
                size += this.sendBuffer[i].remaining();
                ++i;
            }
            this.sendBuffer[0] = ByteBuffer.allocate(4);
            this.sendBuffer[0].putInt(size);
            this.sendBuffer[0].flip();
            this.log.trace((Object)("+OP_WRITE " + this.selectionKey));
            this.selectorManager.addInterestOps(this.selectionKey, 4);
        }
        catch (InterruptedException e) {
            this.log.error((Object)"Communications error, closing connection: ", (Throwable)e);
            this.close();
            throw new ProtocolException(e);
        }
    }

    public void flush() throws ProtocolException {
        try {
            this.log.trace((Object)("flush AQUIRING " + this.sendMutex));
            if (!this.sendMutex.attempt(this.timeout)) {
                throw new ProtocolException("Send timeout.");
            }
            this.log.trace((Object)("flush AQUIRED " + this.sendMutex));
            this.log.trace((Object)("flush RELEASING " + this.sendMutex));
            this.sendMutex.release();
            this.log.trace((Object)("flush RELEASED " + this.sendMutex));
        }
        catch (InterruptedException e) {
            this.log.error((Object)"Communications error, closing connection: ", (Throwable)e);
            this.close();
            throw new ProtocolException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectionEvent(SelectorManager.Event event) {
        block9: {
            try {
                Object object;
                if (event.isReadable()) {
                    object = this.serviceReadMutex;
                    synchronized (object) {
                        this.serviceRead();
                    }
                }
                if (!event.isWritable()) break block9;
                object = this.serviceWriteMutex;
                synchronized (object) {
                    this.serviceWrite();
                }
            }
            catch (CancelledKeyException e) {
                this.log.trace((Object)("CancelledKeyException " + e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceWrite() {
        this.log.trace((Object)("serviceWrite() triggered " + this.selectionKey));
        try {
            if (this.sendBuffer == null) {
                this.log.trace((Object)"Write had allready been serviced.");
                return;
            }
            long count = this.socketChannel.write(this.sendBuffer);
            this.log.trace((Object)("Wrote " + count));
            for (int i = 0; i < this.sendBuffer.length; ++i) {
                if (!this.sendBuffer[i].hasRemaining()) continue;
                this.log.trace((Object)("+OP_WRITE " + this.selectionKey));
                this.selectorManager.addInterestOps(this.selectionKey, 4);
                return;
            }
            this.sendBuffer = null;
            this.log.trace((Object)("RELEASING " + this.sendMutex));
            this.sendMutex.release();
            this.log.trace((Object)("RELEASED " + this.sendMutex));
        }
        catch (IOException e) {
            if (!"A non-blocking socket operation could not be completed immediately".equals(e.getMessage())) {
                this.log.warn((Object)"Communications error, closing connection: ", (Throwable)e);
                this.close();
            }
        }
        finally {
            this.log.trace((Object)"serviceWrite() done.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceRead() {
        boolean tracing = this.log.isTraceEnabled();
        if (tracing) {
            this.log.trace((Object)("serviceRead() triggered " + this.selectionKey));
        }
        this.lastUsed = System.currentTimeMillis();
        try {
            while (true) {
                long count;
                this.log.trace((Object)("HEADER reamining " + this.headerBuffer.remaining()));
                if (this.headerBuffer.hasRemaining()) {
                    if (tracing) {
                        this.log.trace((Object)"Reading header");
                    }
                    count = this.socketChannel.read(this.headerBuffer);
                    this.log.trace((Object)("HEADER Read " + count));
                    if (count == -1L) {
                        this.close();
                        return;
                    }
                    if (this.headerBuffer.hasRemaining()) {
                        this.log.trace((Object)("HEADER reamining " + this.headerBuffer.remaining()));
                        break;
                    }
                    this.headerBuffer.flip();
                    int size = this.headerBuffer.getInt();
                    this.log.trace((Object)("Gotta get " + size));
                    if (size == 0) {
                        this.headerBuffer.clear();
                        this.log.trace((Object)("+OP_READ " + this.selectionKey));
                        this.selectorManager.addInterestOps(this.selectionKey, 1);
                        return;
                    }
                    this.bodyBuffer = ByteBuffer.allocate(size);
                    this.bodyBuffer.clear();
                    this.bodyBuffer.limit(size);
                }
                this.log.trace((Object)("BODY... HEADER remaining: " + this.headerBuffer.remaining() + ", " + this.headerBuffer.hasRemaining()));
                if (!this.bodyBuffer.hasRemaining()) continue;
                if (tracing) {
                    this.log.trace((Object)"Reading body");
                }
                count = this.socketChannel.read(this.bodyBuffer);
                this.log.trace((Object)("BODY Read " + count));
                this.log.trace((Object)("BODY remaining " + this.bodyBuffer.remaining()));
                if (this.bodyBuffer.hasRemaining()) break;
                this.bodyBuffer.flip();
                UpPacket packet = new UpPacket();
                packet.setBuffer(this.bodyBuffer);
                this.bodyBuffer = null;
                this.headerBuffer.clear();
                this.up.sendUp(packet);
            }
            this.log.trace((Object)("+OP_READ " + this.selectionKey));
            this.selectorManager.addInterestOps(this.selectionKey, 1);
            if (tracing) {
                this.log.trace((Object)"No more data available to be read.");
            }
        }
        catch (CancelledKeyException e) {
        }
        catch (ClosedChannelException e) {
        }
        catch (IOException e) {
            this.log.trace((Object)"Communications error, closing connection: ", (Throwable)e);
            this.close();
        }
        catch (ProtocolException e) {
            this.log.trace((Object)"Communications error, closing connection: ", (Throwable)e);
            this.close();
        }
        catch (Throwable e) {
            this.log.trace((Object)"Unhandled error, closing connection: ", e);
            this.close();
        }
        finally {
            if (tracing) {
                this.log.trace((Object)"serviceRead() done.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        SocketProtocol socketProtocol = this;
        synchronized (socketProtocol) {
            if (this.state == 0) {
                this.log.trace((Object)"Closing");
                try {
                    this.selectorManager.closeChannel(this.socketChannel);
                }
                catch (Throwable e) {
                    this.log.info((Object)"Closing error: ", e);
                }
                this.log.trace((Object)("Closed " + this));
            }
            this.state = 1;
        }
    }

    public void accept(SocketChannel socketChannel) {
        this.acceptedSocketChannel = socketChannel;
    }
}

