/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.network.protocol;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import java.nio.channels.SocketChannel;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.network.protocol.AcceptableProtocol;
import org.apache.geronimo.network.protocol.ProtocolException;
import org.apache.geronimo.network.protocol.ServerSocketAcceptorListener;
import org.apache.geronimo.pool.ClockPool;

public class ProtocolFactory
implements ServerSocketAcceptorListener {
    private static final Log log = LogFactory.getLog((Class)ProtocolFactory.class);
    private static final AcceptedCallBack NULL_CALLBACK = new AcceptedCallBack(){

        public void accepted(AcceptableProtocol aProtocol) {
        }
    };
    private AcceptedCallBack callBack = NULL_CALLBACK;
    private AcceptableProtocol template;
    private ClockPool clockPool;
    private Map connectionCache = new Hashtable();
    private static volatile long nextConnectionId = 0L;
    private long reclaimPeriod;
    private long maxAge;
    private long maxInactivity;

    public AcceptedCallBack getAcceptedCallBack() {
        return this.callBack;
    }

    public void setAcceptedCallBack(AcceptedCallBack aCallBack) {
        this.callBack = aCallBack;
    }

    public AcceptableProtocol getTemplate() {
        return this.template;
    }

    public void setTemplate(AcceptableProtocol template) {
        this.template = template;
    }

    public ClockPool getClockPool() {
        return this.clockPool;
    }

    public void setClockPool(ClockPool clockPool) {
        this.clockPool = clockPool;
    }

    public long getReclaimPeriod() {
        return this.reclaimPeriod;
    }

    public void setReclaimPeriod(long reclaimPeriod) {
        this.reclaimPeriod = reclaimPeriod;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(long maxAge) {
        this.maxAge = maxAge;
    }

    public long getMaxInactivity() {
        return this.maxInactivity;
    }

    public void setMaxInactivity(long maxInactivity) {
        this.maxInactivity = maxInactivity;
    }

    public void accept(SocketChannel socketChannel) {
        try {
            AcceptableProtocol protocol = (AcceptableProtocol)this.template.cloneProtocol();
            protocol.accept(socketChannel);
            this.callBack.accepted(protocol);
            protocol.setup();
            Long id = new Long(nextConnectionId++);
            ConnectionCacheMonitor ccm = new ConnectionCacheMonitor(id, protocol, this.maxAge, this.maxInactivity);
            ccm.clockTicket = this.clockPool.getClockDaemon().executePeriodically(this.reclaimPeriod, (Runnable)ccm, true);
            this.connectionCache.put(id, ccm);
            log.trace((Object)("Connection [" + ccm.key + "] accepted"));
        }
        catch (CloneNotSupportedException e) {
            log.error((Object)("Error accepting connection from " + socketChannel.socket().getInetAddress() + " " + e));
        }
        catch (ProtocolException e) {
            log.error((Object)("Error accepting connection from " + socketChannel.socket().getInetAddress() + " " + e));
        }
    }

    public void startup() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drain() throws Exception {
        Map map = this.connectionCache;
        synchronized (map) {
            Iterator keys = this.connectionCache.keySet().iterator();
            while (keys.hasNext()) {
                ConnectionCacheMonitor ccm = (ConnectionCacheMonitor)this.connectionCache.get(keys.next());
                ClockDaemon.cancel((Object)ccm.clockTicket);
                if (!ccm.connection.isDone()) {
                    try {
                        ccm.connection.drain();
                    }
                    catch (ProtocolException pe) {
                        // empty catch block
                    }
                }
                log.trace((Object)("Connection [" + ccm.key + "] reclaimed"));
            }
            this.connectionCache.clear();
        }
    }

    public void teardown() {
    }

    private class ConnectionCacheMonitor
    implements Runnable {
        final Long key;
        final AcceptableProtocol connection;
        final long maxAge;
        final long maxInactivity;
        Object clockTicket;

        ConnectionCacheMonitor(Long key, AcceptableProtocol connection, long maxAge, long maxInactivity) {
            this.key = key;
            this.connection = connection;
            this.maxAge = maxAge;
            this.maxInactivity = maxInactivity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Map map = ProtocolFactory.this.connectionCache;
                synchronized (map) {
                    long currentTime = System.currentTimeMillis();
                    if (this.connection.isDone() || currentTime - this.connection.getCreated() > this.maxAge || currentTime - this.connection.getLastUsed() > this.maxInactivity) {
                        log.trace((Object)("Connection [" + this.key + "] reclaimed"));
                        if (!this.connection.isDone()) {
                            this.connection.drain();
                        }
                        ClockDaemon.cancel((Object)this.clockTicket);
                        ProtocolFactory.this.connectionCache.remove(this.key);
                    }
                }
            }
            catch (ProtocolException e) {
                e.printStackTrace();
            }
        }
    }

    public static interface AcceptedCallBack {
        public void accepted(AcceptableProtocol var1) throws ProtocolException;
    }
}

