/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.network.protocol;

import EDU.oswego.cs.dl.util.concurrent.Latch;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.network.protocol.AbstractProtocol;
import org.apache.geronimo.network.protocol.DownPacket;
import org.apache.geronimo.network.protocol.PlainDownPacket;
import org.apache.geronimo.network.protocol.ProtocolException;
import org.apache.geronimo.network.protocol.UpPacket;
import org.apache.geronimo.pool.ThreadPool;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public class GSSAPIClientProtocol
extends AbstractProtocol {
    private static final Log log = LogFactory.getLog((Class)GSSAPIClientProtocol.class);
    private ThreadPool threadPool;
    private String serverNameString;
    private GSSContext context;
    private boolean mutualAuth;
    private boolean confidential;
    private boolean integrity;
    Latch startupLatch = new Latch();

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public String getServerNameString() {
        return this.serverNameString;
    }

    public void setServerNameString(String serverNameString) {
        this.serverNameString = serverNameString;
    }

    public boolean isMutualAuth() {
        return this.mutualAuth;
    }

    public void setMutualAuth(boolean mutualAuth) {
        this.mutualAuth = mutualAuth;
    }

    public void setMutualAuth(Boolean mutualAuth) {
        this.mutualAuth = mutualAuth;
    }

    public boolean isConfidential() {
        return this.confidential;
    }

    public void setConfidential(boolean confidential) {
        this.confidential = confidential;
    }

    public void setConfidential(Boolean confidential) {
        this.confidential = confidential;
    }

    public boolean isIntegrity() {
        return this.integrity;
    }

    public void setIntegrity(boolean integrity) {
        this.integrity = integrity;
    }

    public void setIntegrity(Boolean integrity) {
        this.integrity = integrity;
    }

    public void setup() throws ProtocolException {
        log.trace((Object)"Starting");
        try {
            Oid krb5Oid = new Oid("1.2.840.113554.1.2.2");
            GSSManager manager = GSSManager.getInstance();
            GSSName serverName = manager.createName(this.serverNameString, null);
            this.context = manager.createContext(serverName, krb5Oid, null, 0);
            this.context.requestMutualAuth(this.mutualAuth);
            this.context.requestConf(this.confidential);
            this.context.requestInteg(this.integrity);
            this.context.requestCredDeleg(true);
            this.threadPool.execute(new Runnable(){

                public void run() {
                    try {
                        byte[] token = new byte[]{};
                        token = GSSAPIClientProtocol.this.context.initSecContext(token, 0, token.length);
                        PlainDownPacket packet = new PlainDownPacket();
                        packet.setBuffers(Collections.singletonList(ByteBuffer.allocate(token.length).put(token).flip()));
                        GSSAPIClientProtocol.this.getDownProtocol().sendDown(packet);
                    }
                    catch (ProtocolException e) {
                    }
                    catch (GSSException gSSException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (GSSException e) {
            throw new ProtocolException(e);
        }
        catch (InterruptedException e) {
            throw new ProtocolException(e);
        }
    }

    public void drain() throws ProtocolException {
        log.trace((Object)"Stoping");
    }

    public void teardown() throws ProtocolException {
    }

    public void sendUp(UpPacket packet) throws ProtocolException {
        try {
            log.trace((Object)"sendUp");
            if (!this.context.isEstablished()) {
                ByteBuffer buffer = packet.getBuffer();
                byte[] token = this.context.initSecContext(buffer.array(), buffer.position(), buffer.remaining());
                if (!this.context.isEstablished()) {
                    PlainDownPacket reply = new PlainDownPacket();
                    reply.setBuffers(Collections.singletonList(ByteBuffer.allocate(token.length).put(token).flip()));
                    this.getDownProtocol().sendDown(reply);
                } else {
                    log.trace((Object)"SECURE CONTEXT ESTABLISHED");
                    log.trace((Object)("Client is " + this.context.getSrcName()));
                    log.trace((Object)("Server is " + this.context.getTargName()));
                    if (this.context.getMutualAuthState()) {
                        log.trace((Object)"MUTUAL AUTHENTICATION IN PLACE");
                    }
                    if (this.context.getConfState()) {
                        log.trace((Object)"CONFIDENTIALITY IN PLACE");
                    }
                    if (this.context.getIntegState()) {
                        log.trace((Object)"INTEGRITY IN PLACE");
                    }
                    log.trace((Object)("RELEASING " + this.startupLatch));
                    this.startupLatch.release();
                    log.trace((Object)("RELEASED " + this.startupLatch));
                }
            } else {
                ByteBuffer buffer = packet.getBuffer();
                byte[] token = this.context.unwrap(buffer.array(), buffer.position(), buffer.remaining(), new MessageProp(0, true));
                UpPacket message = new UpPacket();
                message.setBuffer((ByteBuffer)ByteBuffer.allocate(token.length).put(token).flip());
                this.getUpProtocol().sendUp(message);
            }
        }
        catch (GSSException e) {
            throw new ProtocolException(e);
        }
    }

    public void sendDown(DownPacket packet) throws ProtocolException {
        try {
            log.trace((Object)"sendDown");
            log.trace((Object)("AQUIRING " + this.startupLatch));
            if (!this.startupLatch.attempt(1000000L)) {
                throw new ProtocolException("Send timeout");
            }
            log.trace((Object)("AQUIRED " + this.startupLatch));
            int size = 0;
            Iterator iter = packet.getBuffers().iterator();
            while (iter.hasNext()) {
                size += ((ByteBuffer)iter.next()).remaining();
            }
            ByteBuffer buffer = ByteBuffer.allocate(size);
            Iterator iter2 = packet.getBuffers().iterator();
            while (iter2.hasNext()) {
                buffer.put((ByteBuffer)iter2.next());
            }
            buffer.flip();
            byte[] token = this.context.wrap(buffer.array(), buffer.position(), buffer.remaining(), new MessageProp(0, true));
            PlainDownPacket reply = new PlainDownPacket();
            reply.setBuffers(Collections.singletonList(ByteBuffer.allocate(token.length).put(token).flip()));
            this.getDownProtocol().sendDown(reply);
        }
        catch (GSSException e) {
            throw new ProtocolException(e);
        }
        catch (InterruptedException e) {
            throw new ProtocolException(e);
        }
    }

    public void flush() throws ProtocolException {
        this.getDownProtocol().flush();
    }
}

