/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.network.protocol;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.network.SelectionEventListner;
import org.apache.geronimo.network.SelectorManager;
import org.apache.geronimo.network.protocol.DatagramDownPacket;
import org.apache.geronimo.network.protocol.DatagramUpPacket;
import org.apache.geronimo.network.protocol.DownPacket;
import org.apache.geronimo.network.protocol.Protocol;
import org.apache.geronimo.network.protocol.ProtocolException;
import org.apache.geronimo.network.protocol.UpPacket;

public class DatagramProtocol
implements Protocol,
SelectionEventListner {
    private static final Log log = LogFactory.getLog((Class)DatagramProtocol.class);
    private Protocol up;
    private URI connectURI;
    private DatagramChannel source;
    private DatagramChannel destination;
    private InetSocketAddress sourceAddress;
    private InetSocketAddress destinationInterface;
    private SelectorManager selectorManager;
    private SelectionKey selectionKey;
    private final int STARTED = 0;
    private final int STOPPED = 1;
    private int state = 1;
    ByteBuffer receiveBuffer = ByteBuffer.allocate(65336);

    public Protocol getUpProtocol() {
        return this.up;
    }

    public void setUpProtocol(Protocol up) {
        this.up = up;
    }

    public Protocol getDownProtocol() {
        throw new UnsupportedOperationException("Datagram protocol is at the bottom");
    }

    public void setDownProtocol(Protocol down) {
        throw new UnsupportedOperationException("Datagram protocol is at the bottom");
    }

    public URI getConnectURI() {
        return this.connectURI;
    }

    public SocketAddress getSourceAddress() {
        return this.sourceAddress;
    }

    public void setSourceAddress(InetSocketAddress sourceAddress) {
        if (this.state == 0) {
            throw new IllegalStateException("Protocol already started");
        }
        this.sourceAddress = sourceAddress;
    }

    public SocketAddress getDestinationInterface() {
        return this.destinationInterface;
    }

    public void setDestinationInterface(InetSocketAddress destinationInterface) {
        if (this.state == 0) {
            throw new IllegalStateException("Protocol already started");
        }
        this.destinationInterface = destinationInterface;
    }

    public SelectorManager getSelectorManager() {
        return this.selectorManager;
    }

    public void setSelectorManager(SelectorManager selectorManager) {
        if (this.state == 0) {
            throw new IllegalStateException("Protocol already started");
        }
        this.selectorManager = selectorManager;
    }

    public void clearLinks() {
        this.up = null;
    }

    public Protocol cloneProtocol() throws CloneNotSupportedException {
        return (Protocol)super.clone();
    }

    public void setup() throws ProtocolException {
        try {
            if (this.sourceAddress != null) {
                this.source = DatagramChannel.open();
                this.source.configureBlocking(true);
                this.source.socket().bind(this.sourceAddress);
                this.source.socket().setReuseAddress(true);
                this.source.configureBlocking(false);
                this.selectionKey = this.selectorManager.register(this.source, 1, this);
                this.connectURI = new URI("async", null, this.sourceAddress.getHostName(), this.source.socket().getLocalPort(), "", "", null);
                log.info((Object)("Datagram protocol available at: " + this.sourceAddress.getHostName() + ":" + this.source.socket().getLocalPort()));
                log.info((Object)("Datagram protocol clients will send datagrams to: " + this.connectURI));
            }
            if (this.destinationInterface != null) {
                this.destination = DatagramChannel.open();
                this.destination.configureBlocking(true);
                this.destination.socket().bind(this.destinationInterface);
                this.destination.socket().setReuseAddress(true);
            }
        }
        catch (SocketException e) {
            this.state = 1;
            throw new ProtocolException(e);
        }
        catch (IOException e) {
            this.state = 1;
            throw new ProtocolException(e);
        }
        catch (URISyntaxException e) {
            this.state = 1;
            throw new ProtocolException(e);
        }
        this.state = 0;
    }

    public void drain() throws ProtocolException {
        this.close();
        this.state = 1;
    }

    public void teardown() throws ProtocolException {
    }

    public void sendUp(UpPacket packet) throws ProtocolException {
        throw new IllegalAccessError("Method not implemented");
    }

    public void sendDown(DownPacket packet) throws ProtocolException {
        if (this.state == 1) {
            throw new IllegalStateException("Protocol is not started");
        }
        if (this.destinationInterface == null) {
            throw new IllegalStateException("No detestination address set");
        }
        if (!(packet instanceof DatagramDownPacket)) {
            throw new IllegalArgumentException("DownPacket not instance of DatagramDownPacket");
        }
        DatagramDownPacket datagramPacket = (DatagramDownPacket)packet;
        try {
            ByteBuffer buffer;
            Collection patcketBuffers = packet.getBuffers();
            if (patcketBuffers.size() > 1) {
                int size = 0;
                Iterator iter = patcketBuffers.iterator();
                while (iter.hasNext()) {
                    size += ((ByteBuffer)iter.next()).remaining();
                }
                buffer = ByteBuffer.allocate(size);
                iter = patcketBuffers.iterator();
                while (iter.hasNext()) {
                    buffer.put((ByteBuffer)iter.next());
                }
                buffer.flip();
            } else {
                buffer = (ByteBuffer)patcketBuffers.iterator().next();
            }
            this.destination.send(buffer, datagramPacket.getAddress());
        }
        catch (IOException e) {
            this.state = 1;
            throw new ProtocolException(e);
        }
    }

    public void flush() throws ProtocolException {
    }

    public synchronized void selectionEvent(SelectorManager.Event event) {
        boolean tracing = log.isTraceEnabled();
        if (tracing) {
            log.trace((Object)"ReadDataAction triggered.");
        }
        try {
            SocketAddress address = this.source.receive(this.receiveBuffer);
            if (address == null) {
                return;
            }
            this.receiveBuffer.flip();
            ByteBuffer packetBuffer = ByteBuffer.allocate(this.receiveBuffer.remaining());
            packetBuffer.put(this.receiveBuffer);
            packetBuffer.flip();
            DatagramUpPacket packet = new DatagramUpPacket();
            packet.setBuffer(packetBuffer);
            packet.setAddress(address);
            this.up.sendUp(packet);
            this.receiveBuffer.clear();
            this.selectorManager.addInterestOps(this.selectionKey, 1);
        }
        catch (IOException e) {
            log.debug((Object)"Communications error, closing connection: ", (Throwable)e);
            this.close();
        }
        catch (ProtocolException e) {
            log.debug((Object)"Communications error, closing connection: ", (Throwable)e);
            this.close();
        }
    }

    public synchronized void close() {
        if (this.source != null) {
            try {
                this.selectionKey.cancel();
                this.source.close();
            }
            catch (Throwable e) {
                // empty catch block
            }
            this.source = null;
        }
        if (this.destination != null) {
            try {
                this.destination.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.destination = null;
        }
        this.state = 1;
    }
}

