/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.network.protocol;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.network.protocol.AbstractProtocol;
import org.apache.geronimo.network.protocol.DownPacket;
import org.apache.geronimo.network.protocol.ProtocolException;
import org.apache.geronimo.network.protocol.SocketProtocol;
import org.apache.geronimo.network.protocol.UpPacket;
import org.apache.geronimo.network.protocol.control.BootstrapCook;
import org.apache.geronimo.network.protocol.control.ControlContext;
import org.apache.geronimo.network.protocol.control.commands.CreateInstanceMenuItem;

public class CountingProtocol
extends AbstractProtocol
implements BootstrapCook {
    private static final Log log = LogFactory.getLog((Class)SocketProtocol.class);
    private volatile long upCount;
    private volatile long downCount;
    private boolean tracing;

    public long getUpCount() {
        return this.upCount;
    }

    public long getDownCount() {
        return this.downCount;
    }

    public void setup() throws ProtocolException {
        this.tracing = log.isTraceEnabled();
        if (this.tracing) {
            log.trace((Object)"Starting");
        }
    }

    public void drain() throws ProtocolException {
        if (this.tracing) {
            log.trace((Object)"Stopping");
        }
    }

    public void teardown() throws ProtocolException {
    }

    public void sendUp(UpPacket packet) throws ProtocolException {
        if (this.tracing) {
            log.trace((Object)("sendUp " + this.upCount));
        }
        ++this.upCount;
        this.getUpProtocol().sendUp(packet);
    }

    public void sendDown(DownPacket packet) throws ProtocolException {
        if (this.tracing) {
            log.trace((Object)("sendDown " + this.downCount));
        }
        ++this.downCount;
        this.getDownProtocol().sendDown(packet);
    }

    public void flush() throws ProtocolException {
        this.getDownProtocol().flush();
    }

    public Collection cook(ControlContext context) {
        CreateInstanceMenuItem item = new CreateInstanceMenuItem();
        item.setClassName(CountingProtocol.class.getName());
        item.setInstanceId(context.assignId(this));
        return Collections.singletonList(item);
    }
}

