/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.network.protocol;

import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.network.protocol.AbstractProtocol;
import org.apache.geronimo.network.protocol.DownPacket;
import org.apache.geronimo.network.protocol.ProtocolException;
import org.apache.geronimo.network.protocol.UpPacket;
import org.apache.geronimo.network.protocol.control.BootstrapCook;
import org.apache.geronimo.network.protocol.control.ControlContext;
import org.apache.geronimo.network.protocol.control.commands.CreateInstanceMenuItem;
import org.apache.geronimo.network.protocol.control.commands.MenuItemPacketField;
import org.apache.geronimo.network.protocol.control.commands.SetReferenceMenuItem;
import org.apache.geronimo.pool.ThreadPool;

public class BufferProtocol
extends AbstractProtocol
implements BootstrapCook {
    private static final Log log = LogFactory.getLog((Class)BufferProtocol.class);
    private ThreadPool threadPool;
    private LinkedQueue upQueue = new LinkedQueue();
    private LinkedQueue downQueue = new LinkedQueue();
    private boolean running = false;
    private ProtocolException error = null;

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public void setup() throws ProtocolException {
        log.trace((Object)"Starting");
        this.running = true;
        try {
            this.threadPool.execute(new Runnable(){

                public void run() {
                    try {
                        while (BufferProtocol.this.running) {
                            UpPacket packet = (UpPacket)BufferProtocol.this.upQueue.take();
                            if (packet == null) continue;
                            BufferProtocol.this.getUpProtocol().sendUp(packet);
                        }
                    }
                    catch (InterruptedException e) {
                    }
                    catch (ProtocolException e) {
                        BufferProtocol.this.running = false;
                        BufferProtocol.this.error = e;
                    }
                }
            });
            this.threadPool.execute(new Runnable(){

                public void run() {
                    try {
                        while (BufferProtocol.this.running) {
                            DownPacket packet = (DownPacket)BufferProtocol.this.downQueue.take();
                            if (packet == null) continue;
                            BufferProtocol.this.getDownProtocol().sendDown(packet);
                        }
                    }
                    catch (InterruptedException e) {
                    }
                    catch (ProtocolException e) {
                        BufferProtocol.this.running = false;
                        BufferProtocol.this.error = e;
                    }
                }
            });
        }
        catch (InterruptedException e) {
            throw new ProtocolException(e);
        }
    }

    public void drain() throws ProtocolException {
        log.trace((Object)"Stopping");
        this.running = false;
    }

    public void teardown() throws ProtocolException {
    }

    public void sendUp(UpPacket packet) throws ProtocolException {
        if (this.error != null) {
            throw this.error;
        }
        try {
            this.upQueue.put((Object)packet);
        }
        catch (InterruptedException e) {
            throw new ProtocolException(e);
        }
    }

    public void sendDown(DownPacket packet) throws ProtocolException {
        if (this.error != null) {
            throw this.error;
        }
        try {
            this.downQueue.put((Object)packet);
        }
        catch (InterruptedException e) {
            throw new ProtocolException(e);
        }
    }

    public void flush() throws ProtocolException {
        try {
            DownPacket packet;
            while (this.running && (packet = (DownPacket)this.downQueue.peek()) != null) {
                Thread.sleep(50L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Collection cook(ControlContext context) {
        ArrayList<MenuItemPacketField> list = new ArrayList<MenuItemPacketField>(2);
        CreateInstanceMenuItem create = new CreateInstanceMenuItem();
        create.setClassName("org.apache.geronimo.network.protocol.BufferProtocol");
        create.setInstanceId(context.assignId(this));
        list.add(create);
        SetReferenceMenuItem set = new SetReferenceMenuItem();
        set.setInstanceId(context.assignId(this));
        set.setReferenceName("ThreadPool");
        set.setReferenceId(context.assignId(this.threadPool));
        list.add(set);
        return list;
    }
}

