/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.network.protocol;

import java.nio.channels.SocketChannel;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.network.protocol.AcceptableProtocol;
import org.apache.geronimo.network.protocol.DownPacket;
import org.apache.geronimo.network.protocol.Protocol;
import org.apache.geronimo.network.protocol.ProtocolException;
import org.apache.geronimo.network.protocol.UpPacket;

public class AcceptableProtocolStack
extends Stack
implements AcceptableProtocol {
    private static final Log log = LogFactory.getLog((Class)AcceptableProtocolStack.class);
    private Protocol top;
    private AcceptableProtocol bottom;

    public Object push(Object object) {
        if (this.empty()) {
            this.top = (Protocol)object;
            this.bottom = (AcceptableProtocol)object;
        } else {
            this.top = (Protocol)object;
            Protocol down = (Protocol)super.peek();
            this.top.setUpProtocol(down.getUpProtocol());
            this.top.setDownProtocol(down);
            down.setUpProtocol(this.top);
        }
        return super.push(object);
    }

    public Object pop() {
        if (this.size() == 1) {
            this.top = null;
            this.bottom = null;
        }
        Protocol result = (Protocol)super.pop();
        this.top = (Protocol)super.peek();
        this.top.setUpProtocol(result.getUpProtocol());
        result.setUpProtocol(null);
        result.setDownProtocol(null);
        return result;
    }

    public Protocol getUpProtocol() {
        return this.top.getUpProtocol();
    }

    public void setUpProtocol(Protocol up) {
        this.top.setUpProtocol(up);
    }

    public Protocol getDownProtocol() {
        return this.bottom.getDownProtocol();
    }

    public void setDownProtocol(Protocol down) {
        this.bottom.setDownProtocol(down);
    }

    public void clearLinks() {
        this.top.setUpProtocol(null);
        this.bottom.setDownProtocol(null);
    }

    public Protocol cloneProtocol() throws CloneNotSupportedException {
        AcceptableProtocolStack stack = new AcceptableProtocolStack();
        for (int i = 0; i < this.size(); ++i) {
            Protocol protocol = ((Protocol)this.get(i)).cloneProtocol();
            protocol.clearLinks();
            stack.push(protocol);
        }
        return stack;
    }

    public void setup() throws ProtocolException {
        log.trace((Object)"Starting");
        for (int i = 0; i < this.size(); ++i) {
            Protocol protocol = (Protocol)this.get(i);
            protocol.setup();
        }
    }

    public void drain() throws ProtocolException {
        log.trace((Object)"Stopping");
        for (int i = this.size() - 1; 0 <= i; --i) {
            Protocol protocol = (Protocol)this.get(i);
            protocol.drain();
        }
    }

    public void teardown() throws ProtocolException {
    }

    public void sendUp(UpPacket packet) throws ProtocolException {
        this.bottom.sendUp(packet);
    }

    public void sendDown(DownPacket packet) throws ProtocolException {
        this.top.sendDown(packet);
    }

    public void flush() throws ProtocolException {
        this.top.flush();
    }

    public void accept(SocketChannel socketChannel) {
        this.bottom.accept(socketChannel);
    }

    public boolean isDone() {
        return this.bottom.isDone();
    }

    public long getCreated() {
        return this.bottom.getCreated();
    }

    public long getLastUsed() {
        return this.bottom.getLastUsed();
    }
}

