/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.network;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.WaitingException;
import org.apache.geronimo.network.SelectionEventListner;
import org.apache.geronimo.pool.ThreadPool;

public class SelectorManager
implements Runnable,
GBeanLifecycle {
    private static final Log log = LogFactory.getLog((Class)SelectorManager.class);
    private ThreadPool threadPool;
    private volatile boolean running;
    private Selector selector;
    private long timeout;
    private ThreadGroup threadGroup;
    private String threadName;
    private int startCounter;
    private Stack closing = new Stack();
    private static final GBeanInfo GBEAN_INFO;

    public SelectorManager() throws IOException {
        this.threadGroup = new ThreadGroup("Geronimo NIO Workers");
        this.selector = Selector.open();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            log.debug((Object)"Selector Work thread has started.");
            log.debug((Object)("Selector Manager timeout: " + this.timeout));
            while (this.running) {
                try {
                    Stack stack = this.closing;
                    synchronized (stack) {
                        if (!this.closing.isEmpty()) {
                            Iterator iter = this.closing.iterator();
                            while (iter.hasNext()) {
                                SelectableChannel selectableChannel = (SelectableChannel)iter.next();
                                selectableChannel.close();
                            }
                            this.closing.clear();
                        }
                    }
                    log.trace((Object)"Waiting for selector to return.");
                    if (this.selector.select(this.timeout) == 0) {
                        log.trace((Object)"timeout == 0");
                        Iterator<SelectionKey> list = this.selector.selectedKeys().iterator();
                        while (list.hasNext()) {
                            SelectionKey key = list.next();
                            log.trace((Object)("REMOVING " + key));
                            key.channel().close();
                            key.cancel();
                            list.remove();
                        }
                        continue;
                    }
                    Set<SelectionKey> keys = this.selector.selectedKeys();
                    Iterator<SelectionKey> i = keys.iterator();
                    while (i.hasNext()) {
                        SelectionKey key = i.next();
                        if (key.isReadable()) {
                            log.trace((Object)("-OP_READ " + key));
                            key.interestOps(key.interestOps() & 0xFFFFFFFE);
                            this.threadPool.execute((Runnable)new Event(key, 1));
                        }
                        if (key.isWritable()) {
                            log.trace((Object)("-OP_WRITE " + key));
                            key.interestOps(key.interestOps() & 0xFFFFFFFB);
                            this.threadPool.execute((Runnable)new Event(key, 4));
                        }
                        if (key.isAcceptable()) {
                            log.trace((Object)("-OP_ACCEPT " + key));
                            key.interestOps(key.interestOps() & 0xFFFFFFEF);
                            this.threadPool.execute((Runnable)new Event(key, 16));
                        }
                        i.remove();
                    }
                }
                catch (CancelledKeyException e) {
                    log.debug((Object)("Key has Been Cancelled: " + e));
                }
            }
        }
        catch (IOException e) {
            log.warn((Object)"IOException occured.", (Throwable)e);
        }
        catch (InterruptedException e) {
            log.debug((Object)"Selector Work thread has been interrupted.");
        }
        catch (Throwable t) {
            log.error((Object)"Throwable occured.", t);
        }
        finally {
            log.debug((Object)"Selector Work thread has stopped.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectionKey register(SelectableChannel selectableChannel, int ops, SelectionEventListner listener) throws ClosedChannelException {
        Stack stack = this.closing;
        synchronized (stack) {
            this.selector.wakeup();
            SelectionKey key = selectableChannel.register(this.selector, ops, listener);
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannel(SelectableChannel selectableChannel) throws IOException {
        Stack stack = this.closing;
        synchronized (stack) {
            this.selector.wakeup();
            this.closing.push(selectableChannel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInterestOps(SelectionKey selectorKey, int addOpts) {
        Stack stack = this.closing;
        synchronized (stack) {
            this.selector.wakeup();
            selectorKey.interestOps(selectorKey.interestOps() | addOpts);
        }
    }

    public void doStart() throws WaitingException, Exception {
        ++this.startCounter;
        if (this.startCounter == 1) {
            log.debug((Object)"Starting a Selector Work thread.");
            this.running = true;
            new Thread(this.threadGroup, this, this.threadName).start();
        }
    }

    public void doStop() throws WaitingException, Exception {
        --this.startCounter;
        if (this.startCounter == 0) {
            log.debug((Object)"Stopping a Selector Work thread.");
            this.running = false;
            this.selector.wakeup();
        }
    }

    public void doFail() {
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(SelectorManager.class);
        infoFactory.addAttribute("timeout", Long.TYPE, true);
        infoFactory.addReference("ThreadPool", ThreadPool.class);
        infoFactory.addAttribute("threadPool", ThreadPool.class, false);
        infoFactory.addAttribute("threadName", String.class, true);
        infoFactory.addOperation("getSelector");
        infoFactory.addOperation("closeChannel", new Class[]{SelectableChannel.class});
        infoFactory.addOperation("addInterestOps", new Class[]{SelectionKey.class, Integer.TYPE});
        infoFactory.addOperation("register", new Class[]{SelectableChannel.class, Integer.TYPE, SelectionEventListner.class});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }

    public class Event
    implements Runnable {
        final int flags;
        final SelectionKey key;

        private Event(SelectionKey key, int flags) {
            this.flags = flags;
            this.key = key;
        }

        public SelectionKey getSelectionKey() {
            return this.key;
        }

        public final boolean isReadable() {
            return (this.flags & 1) != 0;
        }

        public final boolean isWritable() {
            return (this.flags & 4) != 0;
        }

        public final boolean isAcceptable() {
            return (this.flags & 0x10) != 0;
        }

        public void run() {
            try {
                ((SelectionEventListner)this.key.attachment()).selectionEvent(this);
            }
            catch (Throwable e) {
                log.trace((Object)"Request Failed.", e);
            }
        }
    }
}

