/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.network.protocol.util;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;

public class PacketUtil {
    public static final byte NULL_TYPE = 0;
    public static final byte BOOLEAN_TYPE = 1;
    public static final byte CHARACTER_TYPE = 2;
    public static final byte BYTE_TYPE = 3;
    public static final byte SHORT_TYPE = 4;
    public static final byte INTEGER_TYPE = 5;
    public static final byte LONG_TYPE = 6;
    public static final byte FLOAT_TYPE = 7;
    public static final byte DOUBLE_TYPE = 8;
    public static final byte STRING_TYPE = 9;

    public static ByteBuffer getFirstNonEmpty(Collection packets) {
        Iterator iter = packets.iterator();
        while (iter.hasNext()) {
            ByteBuffer buffer = (ByteBuffer)iter.next();
            if (!buffer.hasRemaining()) continue;
            return buffer;
        }
        return null;
    }

    public static int getRemaining(Collection packets) {
        int remaining = 0;
        Iterator iter = packets.iterator();
        while (iter.hasNext()) {
            remaining += ((ByteBuffer)iter.next()).remaining();
        }
        return remaining;
    }

    public static ByteBuffer consolidate(Collection packets) {
        int size = 0;
        Iterator iter = packets.iterator();
        while (iter.hasNext()) {
            size += ((ByteBuffer)iter.next()).remaining();
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        Iterator iter2 = packets.iterator();
        while (iter2.hasNext()) {
            buffer.put((ByteBuffer)iter2.next());
        }
        return (ByteBuffer)buffer.flip();
    }

    public static boolean isPrimitive(Object object) {
        if (object == null) {
            return true;
        }
        Class<?> type = object.getClass();
        if (type == Boolean.class) {
            return true;
        }
        if (type == Character.class) {
            return true;
        }
        if (type == Byte.class) {
            return true;
        }
        if (type == Short.class) {
            return true;
        }
        if (type == Integer.class) {
            return true;
        }
        if (type == Long.class) {
            return true;
        }
        if (type == Float.class) {
            return true;
        }
        if (type == Double.class) {
            return true;
        }
        return type == String.class;
    }

    public static ByteBuffer putPrimitive(ByteBuffer buffer, Object object) {
        Class<?> type;
        if (object == null) {
            buffer.put((byte)0);
        }
        if ((type = object.getClass()) == Boolean.class) {
            buffer.put((byte)1);
            return PacketUtil.putBoolean(buffer, (Boolean)object);
        }
        if (type == Character.class) {
            buffer.put((byte)2);
            return PacketUtil.putCharacter(buffer, (Character)object);
        }
        if (type == Byte.class) {
            buffer.put((byte)3);
            return PacketUtil.putByte(buffer, (Byte)object);
        }
        if (type == Short.class) {
            buffer.put((byte)4);
            return PacketUtil.putShort(buffer, (Short)object);
        }
        if (type == Integer.class) {
            buffer.put((byte)5);
            return PacketUtil.putInt(buffer, (Integer)object);
        }
        if (type == Long.class) {
            buffer.put((byte)6);
            return PacketUtil.putLong(buffer, (Long)object);
        }
        if (type == Float.class) {
            buffer.put((byte)7);
            return PacketUtil.putFloat(buffer, (Float)object);
        }
        if (type == Double.class) {
            buffer.put((byte)8);
            return PacketUtil.putDouble(buffer, (Double)object);
        }
        if (type == String.class) {
            buffer.put((byte)9);
            return PacketUtil.putString(buffer, (String)object);
        }
        throw new IllegalArgumentException("Object must be a primitive or string");
    }

    public static Object getPrimitive(ByteBuffer buffer) {
        byte type = buffer.get();
        if (type == 0) {
            return null;
        }
        if (type == 1) {
            return PacketUtil.getBoolean(buffer);
        }
        if (type == 2) {
            return PacketUtil.getCharacter(buffer);
        }
        if (type == 3) {
            return PacketUtil.getByte(buffer);
        }
        if (type == 4) {
            return PacketUtil.getShort(buffer);
        }
        if (type == 5) {
            return PacketUtil.getInt(buffer);
        }
        if (type == 6) {
            return PacketUtil.getLong(buffer);
        }
        if (type == 7) {
            return PacketUtil.getFloat(buffer);
        }
        if (type == 8) {
            return PacketUtil.getDouble(buffer);
        }
        if (type == 9) {
            return PacketUtil.getString(buffer);
        }
        throw new IllegalArgumentException("Unknow type encoded in packet");
    }

    public static int getPrimitiveSize(Object object) {
        if (object == null) {
            return 1;
        }
        Class<?> type = object.getClass();
        if (type == Boolean.class) {
            return PacketUtil.getBooleanSize() + 1;
        }
        if (type == Character.class) {
            return PacketUtil.getCharacterSize() + 1;
        }
        if (type == Byte.class) {
            return PacketUtil.getByteSize() + 1;
        }
        if (type == Short.class) {
            return PacketUtil.getShortSize() + 1;
        }
        if (type == Integer.class) {
            return PacketUtil.getIntSize() + 1;
        }
        if (type == Long.class) {
            return PacketUtil.getLongSize() + 1;
        }
        if (type == Float.class) {
            return PacketUtil.getFloatSize() + 1;
        }
        if (type == Double.class) {
            return PacketUtil.getDoubleSize() + 1;
        }
        if (type == String.class) {
            return PacketUtil.getStringSize((String)object) + 1;
        }
        throw new IllegalArgumentException("Object must be a primitive or string");
    }

    public static ByteBuffer putString(ByteBuffer buffer, String string) {
        int size = string.length();
        buffer.putInt(size);
        for (int i = 0; i < size; ++i) {
            buffer.putChar(string.charAt(i));
        }
        return buffer;
    }

    public static ByteBuffer putString(String string) {
        int size = string.length();
        ByteBuffer buffer = ByteBuffer.allocate(4 + size);
        buffer.putInt(size);
        for (int i = 0; i < size; ++i) {
            buffer.putChar(string.charAt(i));
        }
        return buffer;
    }

    public static String getString(ByteBuffer buffer) {
        int size = buffer.getInt();
        StringBuffer name = new StringBuffer(size);
        for (int i = 0; i < size; ++i) {
            name.append(buffer.getChar());
        }
        return name.toString();
    }

    public static int getByteArraySize(byte[] array) {
        return 4 + array.length;
    }

    public static ByteBuffer putByteArray(ByteBuffer buffer, byte[] array) {
        buffer.putInt(array.length);
        buffer.put(array);
        return buffer;
    }

    public static ByteBuffer putByteArray(byte[] array) {
        ByteBuffer buffer = ByteBuffer.allocate(4 + array.length);
        buffer.putInt(array.length);
        buffer.put(array);
        return buffer;
    }

    public static byte[] getByteArray(ByteBuffer buffer) {
        byte[] array = new byte[buffer.getInt()];
        buffer.get(array);
        return array;
    }

    public static int getStringSize(String string) {
        return 4 + 2 * string.length();
    }

    public static ByteBuffer putBoolean(ByteBuffer buffer, Boolean b) {
        buffer.put((byte)(b != false ? 1 : 0));
        return buffer;
    }

    public static ByteBuffer putBoolean(Boolean b) {
        return ByteBuffer.allocate(1).put((byte)(b != false ? 1 : 0));
    }

    public static Boolean getBoolean(ByteBuffer buffer) {
        return new Boolean(buffer.get() == 1);
    }

    public static int getBooleanSize() {
        return 1;
    }

    public static ByteBuffer putCharacter(ByteBuffer buffer, Character c) {
        buffer.putChar(c.charValue());
        return buffer;
    }

    public static ByteBuffer putCharacter(Character c) {
        return ByteBuffer.allocate(2).putChar(c.charValue());
    }

    public static Character getCharacter(ByteBuffer buffer) {
        return new Character(buffer.getChar());
    }

    public static int getCharacterSize() {
        return 2;
    }

    public static ByteBuffer putByte(ByteBuffer buffer, Byte b) {
        buffer.put(b);
        return buffer;
    }

    public static Byte getByte(ByteBuffer buffer) {
        return new Byte(buffer.get());
    }

    public static int getByteSize() {
        return 1;
    }

    public static ByteBuffer putShort(ByteBuffer buffer, Short s) {
        buffer.putShort(s);
        return buffer;
    }

    public static ByteBuffer putShort(Short s) {
        return ByteBuffer.allocate(2).putShort(s);
    }

    public static Short getShort(ByteBuffer buffer) {
        return new Short(buffer.getShort());
    }

    public static int getShortSize() {
        return 2;
    }

    public static ByteBuffer putInt(ByteBuffer buffer, Integer i) {
        buffer.putInt(i);
        return buffer;
    }

    public static ByteBuffer putInt(Integer i) {
        return ByteBuffer.allocate(4).putInt(i);
    }

    public static Integer getInt(ByteBuffer buffer) {
        return new Integer(buffer.getInt());
    }

    public static int getIntSize() {
        return 4;
    }

    public static ByteBuffer putLong(ByteBuffer buffer, Long l) {
        buffer.putLong(l);
        return buffer;
    }

    public static ByteBuffer putLong(Long l) {
        return ByteBuffer.allocate(8).putLong(l);
    }

    public static Long getLong(ByteBuffer buffer) {
        return new Long(buffer.getLong());
    }

    public static int getLongSize() {
        return 8;
    }

    public static ByteBuffer putFloat(ByteBuffer buffer, Float f) {
        buffer.putFloat(f.floatValue());
        return buffer;
    }

    public static ByteBuffer putFloat(Float f) {
        return ByteBuffer.allocate(4).putFloat(f.floatValue());
    }

    public static Float getFloat(ByteBuffer buffer) {
        return new Float(buffer.getFloat());
    }

    public static int getFloatSize() {
        return 4;
    }

    public static ByteBuffer putDouble(ByteBuffer buffer, Double d) {
        buffer.putDouble(d);
        return buffer;
    }

    public static ByteBuffer putDouble(Double d) {
        return ByteBuffer.allocate(8).putDouble(d);
    }

    public static Double getDouble(ByteBuffer buffer) {
        return new Double(buffer.getDouble());
    }

    public static int getDoubleSize() {
        return 8;
    }
}

