/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.network.protocol.control.commands;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import org.apache.geronimo.network.protocol.PacketField;
import org.apache.geronimo.network.protocol.PacketFieldFactory;
import org.apache.geronimo.network.protocol.ProtocolException;
import org.apache.geronimo.network.protocol.control.ControlContext;
import org.apache.geronimo.network.protocol.control.ControlException;
import org.apache.geronimo.network.protocol.control.commands.MenuItem;
import org.apache.geronimo.network.protocol.control.commands.MenuItemPacketField;
import org.apache.geronimo.network.protocol.util.PacketUtil;

public class SetReferenceMenuItem
extends MenuItemPacketField
implements MenuItem,
PacketFieldFactory {
    private Long instanceId;
    private String referenceName;
    private Long referenceId;

    public SetReferenceMenuItem() {
        super((byte)2);
    }

    public Long getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public void setReferenceName(String referenceName) {
        this.referenceName = referenceName;
    }

    public Long getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(Long referenceId) {
        this.referenceId = referenceId;
    }

    protected Collection getChildBuffers() {
        ByteBuffer buffer = ByteBuffer.allocate(PacketUtil.getLongSize() + PacketUtil.getStringSize(this.referenceName) + PacketUtil.getLongSize());
        PacketUtil.putLong(buffer, this.instanceId);
        PacketUtil.putString(buffer, this.referenceName);
        PacketUtil.putLong(buffer, this.referenceId);
        buffer.flip();
        return Collections.singletonList(buffer);
    }

    public PacketField create(ByteBuffer buffer) throws ProtocolException {
        SetReferenceMenuItem item = new SetReferenceMenuItem();
        item.instanceId = PacketUtil.getLong(buffer);
        item.referenceName = PacketUtil.getString(buffer);
        item.referenceId = PacketUtil.getLong(buffer);
        return item;
    }

    public Object execute(ControlContext context) throws ControlException {
        Object target = context.retrieve(this.instanceId);
        Object value = context.retrieve(this.referenceId);
        if (target == null) {
            throw new ControlException("Missing instance: " + this.instanceId);
        }
        try {
            Class<?> clazz = target.getClass();
            Method setter = clazz.getMethod("set" + this.referenceName, value.getClass());
            setter.invoke(target, value);
            return null;
        }
        catch (NoSuchMethodException e) {
            throw new ControlException("Trying to set an attribute", e);
        }
        catch (IllegalAccessException e) {
            throw new ControlException("Trying to set an attribute", e);
        }
        catch (InvocationTargetException e) {
            throw new ControlException("Trying to set an attribute", e);
        }
    }
}

