/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.network.protocol.control.commands;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import org.apache.geronimo.network.protocol.PacketField;
import org.apache.geronimo.network.protocol.PacketFieldFactory;
import org.apache.geronimo.network.protocol.ProtocolException;
import org.apache.geronimo.network.protocol.control.ControlContext;
import org.apache.geronimo.network.protocol.control.ControlException;
import org.apache.geronimo.network.protocol.control.commands.MenuItem;
import org.apache.geronimo.network.protocol.control.commands.MenuItemPacketField;
import org.apache.geronimo.network.protocol.util.PacketUtil;

public class SetAttributeMenuItem
extends MenuItemPacketField
implements MenuItem,
PacketFieldFactory {
    private Long instanceId;
    private String attributeName;
    private Object attributeValue;

    public SetAttributeMenuItem() {
        super((byte)1);
    }

    public Long getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public Object getAttributeValue() {
        return this.attributeValue;
    }

    public void setAttributeValue(Object attributeValue) {
        if (!PacketUtil.isPrimitive(attributeValue)) {
            throw new IllegalArgumentException("Attribute must be a primitive");
        }
        this.attributeValue = attributeValue;
    }

    protected Collection getChildBuffers() {
        ByteBuffer buffer = ByteBuffer.allocate(PacketUtil.getLongSize() + PacketUtil.getStringSize(this.attributeName) + PacketUtil.getPrimitiveSize(this.attributeValue));
        PacketUtil.putLong(buffer, this.instanceId);
        PacketUtil.putString(buffer, this.attributeName);
        PacketUtil.putPrimitive(buffer, this.attributeValue);
        buffer.flip();
        return Collections.singletonList(buffer);
    }

    public PacketField create(ByteBuffer buffer) throws ProtocolException {
        SetAttributeMenuItem item = new SetAttributeMenuItem();
        item.instanceId = PacketUtil.getLong(buffer);
        item.attributeName = PacketUtil.getString(buffer);
        item.attributeValue = PacketUtil.getPrimitive(buffer);
        return item;
    }

    public Object execute(ControlContext context) throws ControlException {
        Object target = context.retrieve(this.instanceId);
        if (target == null) {
            throw new ControlException("Missing instance: " + this.instanceId);
        }
        try {
            Class<?> clazz = target.getClass();
            Method setter = clazz.getMethod("set" + this.attributeName, this.attributeValue.getClass());
            setter = clazz.getMethod("set" + this.attributeName, this.attributeValue.getClass());
            setter.invoke(target, this.attributeValue);
            return null;
        }
        catch (NoSuchMethodException e) {
            throw new ControlException("Trying to set an attribute", e);
        }
        catch (IllegalAccessException e) {
            throw new ControlException("Trying to set an attribute", e);
        }
        catch (InvocationTargetException e) {
            throw new ControlException("Trying to set an attribute", e);
        }
    }
}

