/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.network.protocol.control.commands;

import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Collections;
import org.apache.geronimo.network.protocol.PacketField;
import org.apache.geronimo.network.protocol.PacketFieldFactory;
import org.apache.geronimo.network.protocol.control.ControlContext;
import org.apache.geronimo.network.protocol.control.ControlException;
import org.apache.geronimo.network.protocol.control.commands.MenuItemPacketField;
import org.apache.geronimo.network.protocol.util.PacketUtil;

public class CreateInstanceMenuItem
extends MenuItemPacketField
implements PacketFieldFactory {
    private String className;
    private Long instanceId;

    public CreateInstanceMenuItem() {
        super((byte)0);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Long getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    protected Collection getChildBuffers() {
        ByteBuffer buffer = ByteBuffer.allocate(PacketUtil.getStringSize(this.className) + PacketUtil.getLongSize());
        PacketUtil.putString(buffer, this.className);
        PacketUtil.putLong(buffer, this.instanceId);
        buffer.flip();
        return Collections.singletonList(buffer);
    }

    public PacketField create(ByteBuffer buffer) {
        CreateInstanceMenuItem item = new CreateInstanceMenuItem();
        item.setClassName(PacketUtil.getString(buffer));
        item.setInstanceId(PacketUtil.getLong(buffer));
        return item;
    }

    public Object execute(final ControlContext context) throws ControlException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Object object = Class.forName(CreateInstanceMenuItem.this.className, true, context.getClassLoader()).newInstance();
                    context.register(CreateInstanceMenuItem.this.instanceId, object);
                    return object;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new ControlException(pae.getException());
        }
    }
}

