/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.network.protocol.control;

import EDU.oswego.cs.dl.util.concurrent.Latch;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.network.SelectorManager;
import org.apache.geronimo.network.protocol.AbstractProtocol;
import org.apache.geronimo.network.protocol.DownPacket;
import org.apache.geronimo.network.protocol.Protocol;
import org.apache.geronimo.network.protocol.ProtocolException;
import org.apache.geronimo.network.protocol.ProtocolStack;
import org.apache.geronimo.network.protocol.UpPacket;
import org.apache.geronimo.network.protocol.control.ControlClientListener;
import org.apache.geronimo.network.protocol.control.ControlContext;
import org.apache.geronimo.network.protocol.control.ControlException;
import org.apache.geronimo.network.protocol.control.commands.MenuItem;
import org.apache.geronimo.system.ClockPool;
import org.apache.geronimo.system.ThreadPool;

class ControlClientProtocolKitchen
extends ProtocolStack
implements ControlClientListener {
    private static final Log log = LogFactory.getLog((Class)ControlClientProtocolKitchen.class);
    private ClassLoader classLoader;
    private ThreadPool threadPool;
    private ClockPool clockPool;
    private SelectorManager selectorManager;
    private Latch sendLatch = new Latch();

    ControlClientProtocolKitchen() throws InterruptedException {
        this.push(new Dummy());
    }

    public Protocol cloneProtocol() throws CloneNotSupportedException {
        ControlClientProtocolKitchen p = (ControlClientProtocolKitchen)super.cloneProtocol();
        p.sendLatch = new Latch();
        return p;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public ClockPool getClockPool() {
        return this.clockPool;
    }

    public void setClockPool(ClockPool clockPool) {
        this.clockPool = clockPool;
    }

    public SelectorManager getSelectorManager() {
        return this.selectorManager;
    }

    public void setSelectorManager(SelectorManager selectorManager) {
        this.selectorManager = selectorManager;
    }

    public void serveUp(Collection menu) throws ControlException {
        log.trace((Object)"serveUp");
        ControlContext context = new ControlContext();
        context.setClassLoader(this.classLoader);
        context.setThreadPool(this.threadPool);
        context.setClockPool(this.clockPool);
        context.setSelectorManager(this.selectorManager);
        Iterator iter = menu.iterator();
        while (iter.hasNext()) {
            MenuItem item = (MenuItem)iter.next();
            Object object = item.execute(context);
            if (object == null || !(object instanceof Protocol)) continue;
            this.push((Protocol)object);
        }
        try {
            this.setup();
        }
        catch (ProtocolException e) {
            throw new ControlException(e);
        }
        log.trace((Object)("RELEASING send Latch: " + this.sendLatch));
        this.sendLatch.release();
    }

    public void shutdown() {
    }

    public void sendDown(DownPacket packet) throws ProtocolException {
        try {
            log.trace((Object)("AQUIRING send Latch: " + this.sendLatch));
            if (!this.sendLatch.attempt(1000000L)) {
                throw new ProtocolException("Send timeout.");
            }
            log.trace((Object)("AQUIRED send Latch: " + this.sendLatch));
            super.sendDown(packet);
        }
        catch (InterruptedException e) {
            throw new ProtocolException(e);
        }
    }

    protected class Dummy
    extends AbstractProtocol {
        protected Dummy() {
        }

        public void setup() throws ProtocolException {
        }

        public void drain() throws ProtocolException {
        }

        public void teardown() throws ProtocolException {
        }

        public void sendUp(UpPacket packet) throws ProtocolException {
            this.getUpProtocol().sendUp(packet);
        }

        public void sendDown(DownPacket packet) throws ProtocolException {
            this.getDownProtocol().sendDown(packet);
        }
    }
}

