/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.network.protocol.control;

import EDU.oswego.cs.dl.util.concurrent.Latch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.network.protocol.DownPacket;
import org.apache.geronimo.network.protocol.ProtocolException;
import org.apache.geronimo.network.protocol.UpPacket;
import org.apache.geronimo.network.protocol.control.AbstractControlProtocol;
import org.apache.geronimo.network.protocol.control.BootRequestDownPacket;
import org.apache.geronimo.network.protocol.control.BootResponseUpPacket;
import org.apache.geronimo.network.protocol.control.BootSuccessDownPacket;
import org.apache.geronimo.network.protocol.control.ControlClientListener;
import org.apache.geronimo.network.protocol.control.ControlException;
import org.apache.geronimo.network.protocol.control.ControlPacketReader;
import org.apache.geronimo.network.protocol.control.NoBootUpPacket;
import org.apache.geronimo.network.protocol.control.PassthroughDownPacket;
import org.apache.geronimo.network.protocol.control.PassthroughUpPacket;
import org.apache.geronimo.network.protocol.control.ShutdownAcknowledgeDownPacket;
import org.apache.geronimo.network.protocol.control.ShutdownAcknowledgeUpPacket;
import org.apache.geronimo.network.protocol.control.ShutdownRequestDownPacket;
import org.apache.geronimo.network.protocol.control.ShutdownRequestUpPacket;
import org.apache.geronimo.network.protocol.control.State;

public class ControlClientProtocol
extends AbstractControlProtocol {
    private static final Log log = LogFactory.getLog((Class)ControlClientProtocol.class);
    private ControlClientListener listener;
    private long timeout;
    private final State START = new State(this){
        Latch startupLatch;
        {
            this.startupLatch = new Latch();
        }

        public void sendUp(UpPacket packet) throws ProtocolException {
            UpPacket p = ControlPacketReader.getInstance().read(packet.getBuffer());
            if (p instanceof BootResponseUpPacket) {
                try {
                    log.trace((Object)"BOOT RESPONSE");
                    ControlClientProtocol.this.listener.serveUp(((BootResponseUpPacket)p).getMenu());
                    this.getDownProtocol().sendDown(new BootSuccessDownPacket());
                    log.trace((Object)("RELEASING " + this.startupLatch));
                    ControlClientProtocol.this.state = ControlClientProtocol.this.RUN;
                    this.startupLatch.release();
                    log.trace((Object)("RELEASED " + this.startupLatch));
                }
                catch (ControlException e) {
                    throw new ProtocolException(e);
                }
            } else if (p instanceof NoBootUpPacket) {
                log.trace((Object)"NO BOOT");
                ControlClientProtocol.this.listener.shutdown();
            }
        }

        public void sendDown(DownPacket packet) throws ProtocolException {
            try {
                log.trace((Object)("AQUIRING " + this.startupLatch));
                if (!this.startupLatch.attempt(ControlClientProtocol.this.timeout)) {
                    throw new ProtocolException("Send timeout");
                }
                log.trace((Object)("AQUIRED " + this.startupLatch));
                PassthroughDownPacket passthtough = new PassthroughDownPacket();
                passthtough.setBuffers(packet.getBuffers());
                this.getDownProtocol().sendDown(passthtough);
            }
            catch (InterruptedException e) {
                throw new ProtocolException(e);
            }
        }
    };
    private final State RUN = new State(this){

        public void sendUp(UpPacket packet) throws ProtocolException {
            UpPacket p = ControlPacketReader.getInstance().read(packet.getBuffer());
            if (p instanceof PassthroughUpPacket) {
                log.trace((Object)"PASSTHROUGH");
                this.getUpProtocol().sendUp(packet);
            } else if (p instanceof ShutdownRequestUpPacket) {
                log.trace((Object)"SHUTDOWN_REQ");
                this.getDownProtocol().sendDown(new ShutdownAcknowledgeDownPacket());
                ControlClientProtocol.this.listener.shutdown();
                ControlClientProtocol.this.state = ControlClientProtocol.this.START;
            } else if (p instanceof ShutdownAcknowledgeUpPacket) {
                log.trace((Object)"SHUTDOWN_ACK");
                ControlClientProtocol.this.listener.shutdown();
                ControlClientProtocol.this.state = ControlClientProtocol.this.START;
            }
        }

        public void sendDown(DownPacket packet) throws ProtocolException {
            PassthroughDownPacket passthtough = new PassthroughDownPacket();
            passthtough.setBuffers(packet.getBuffers());
            this.getDownProtocol().sendDown(passthtough);
        }
    };
    private volatile State state = this.START;

    public ControlClientListener getListener() {
        return this.listener;
    }

    public void setListener(ControlClientListener listener) {
        this.listener = listener;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setup() throws ProtocolException {
        log.trace((Object)"Starting");
        this.getDownProtocol().sendDown(new BootRequestDownPacket());
    }

    public void drain() throws ProtocolException {
        log.trace((Object)"Stopping");
        if (this.state == this.RUN) {
            this.getDownProtocol().sendDown(new ShutdownRequestDownPacket());
        }
    }

    public void teardown() throws ProtocolException {
    }

    public void sendUp(UpPacket packet) throws ProtocolException {
        this.state.sendUp(packet);
    }

    public void sendDown(DownPacket packet) throws ProtocolException {
        this.state.sendDown(packet);
    }
}

