/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.network.protocol;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.network.SelectionEventListner;
import org.apache.geronimo.network.SelectorManager;
import org.apache.geronimo.network.URISupport;
import org.apache.geronimo.network.protocol.ServerSocketAcceptorListener;
import org.apache.geronimo.network.protocol.SocketProtocol;

public class ServerSocketAcceptor
implements SelectionEventListner {
    private static final Log log = LogFactory.getLog((Class)SocketProtocol.class);
    private URI uri;
    private URI connectURI;
    private ServerSocketChannel serverSocketChannel;
    private int timeOut;
    private boolean enableTcpNoDelay;
    private SelectorManager selectorManager;
    private SelectionKey selectionKey;
    private ServerSocketAcceptorListener acceptorListener;
    private static final int STARTED = 0;
    private static final int STOPPED = 1;
    private static final int FAILED = 2;
    private int state = 1;

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        if (this.state == 0 || this.state == 2) {
            throw new IllegalStateException("Protocol already started");
        }
        this.uri = uri;
    }

    public URI getConnectURI() {
        return this.connectURI;
    }

    public ServerSocketChannel getServerSocketChannel() {
        return this.serverSocketChannel;
    }

    public void setServerSocketChannel(ServerSocketChannel serverSocketChannel) {
        if (this.state == 0 || this.state == 2) {
            throw new IllegalStateException("Protocol already started");
        }
        this.serverSocketChannel = serverSocketChannel;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(int timeOut) {
        if (this.state == 0 || this.state == 2) {
            throw new IllegalStateException("Protocol already started");
        }
        this.timeOut = timeOut;
    }

    public boolean isEnableTcpNoDelay() {
        return this.enableTcpNoDelay;
    }

    public void setEnableTcpNoDelay(boolean enableTcpNoDelay) {
        if (this.state == 0 || this.state == 2) {
            throw new IllegalStateException("Protocol already started");
        }
        this.enableTcpNoDelay = enableTcpNoDelay;
    }

    public ServerSocketAcceptorListener getAcceptorListener() {
        return this.acceptorListener;
    }

    public void setAcceptorListener(ServerSocketAcceptorListener acceptorListener) {
        if (this.state == 0 || this.state == 2) {
            throw new IllegalStateException("Protocol already started");
        }
        this.acceptorListener = acceptorListener;
    }

    public SelectorManager getSelectorManager() {
        return this.selectorManager;
    }

    public void setSelectorManager(SelectorManager selectorManager) {
        if (this.state == 0 || this.state == 2) {
            throw new IllegalStateException("Protocol already started");
        }
        this.selectorManager = selectorManager;
    }

    public void startup() throws Exception {
        String serverBindAddress = this.uri.getHost();
        int serverBindPort = this.uri.getPort();
        int connectBackLog = 50;
        this.enableTcpNoDelay = true;
        Properties params = URISupport.parseQueryParameters(this.uri);
        this.enableTcpNoDelay = params.getProperty("tcp.nodelay", "true").equals("true");
        connectBackLog = Integer.parseInt(params.getProperty("tcp.backlog", "50"));
        this.serverSocketChannel = ServerSocketChannel.open();
        this.serverSocketChannel.socket().bind(new InetSocketAddress(InetAddress.getByName(serverBindAddress), serverBindPort), connectBackLog);
        this.serverSocketChannel.socket().setSoTimeout(this.timeOut);
        this.serverSocketChannel.configureBlocking(false);
        this.selectionKey = this.selectorManager.register(this.serverSocketChannel, 16, this);
        Properties clientParms = new Properties();
        clientParms.put("tcp.nodelay", this.enableTcpNoDelay ? "true" : "false");
        this.connectURI = new URI("async", null, InetAddress.getByName(serverBindAddress).getHostName(), this.serverSocketChannel.socket().getLocalPort(), "", URISupport.toQueryString(clientParms), null);
        log.info((Object)("Remoting 'async' protocol available at: " + this.serverSocketChannel.socket().getInetAddress() + ":" + this.serverSocketChannel.socket().getLocalPort()));
        log.info((Object)("Remoting 'async' protocol clients will connect to: " + this.connectURI));
        this.state = 0;
    }

    public void drain() throws Exception {
        this.selectionKey.cancel();
        this.serverSocketChannel.close();
        this.state = 1;
    }

    public void teardown() {
        this.state = 1;
    }

    public void selectionEvent(SelectionKey selection) {
        if (selection.isAcceptable()) {
            try {
                ServerSocketChannel server = (ServerSocketChannel)selection.channel();
                SocketChannel channel = server.accept();
                if (channel == null) {
                    return;
                }
                channel.socket().setTcpNoDelay(this.enableTcpNoDelay);
                this.acceptorListener.accept(channel);
                this.selectorManager.addInterestOps(this.selectionKey, 16);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

