/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.network.protocol;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.geronimo.network.protocol.PlainDownPacket;
import org.apache.geronimo.network.protocol.Protocol;
import org.apache.geronimo.network.protocol.ProtocolException;

public class PacketOutputStream
extends OutputStream {
    private final Protocol down;
    private ByteBuffer currentBuffer;
    private short packetSize;
    private boolean closed;

    public PacketOutputStream(Protocol down) {
        this(down, 1024);
    }

    public PacketOutputStream(Protocol down, short packetSize) {
        this.down = down;
        this.packetSize = packetSize;
        this.currentBuffer = ByteBuffer.allocate(packetSize);
        this.closed = false;
    }

    public short getPacketSize() {
        return this.packetSize;
    }

    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("PacketOutputStream closed");
        }
        this.currentBuffer.put((byte)b);
        if (!this.currentBuffer.hasRemaining()) {
            this.flush();
        }
    }

    public void write(byte[] b) throws IOException {
        if (this.closed) {
            throw new IOException("PacketOutputStream closed");
        }
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("PacketOutputStream closed");
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        while (len > 0) {
            int remaining = this.currentBuffer.remaining();
            int segment = Math.min(remaining, len);
            this.currentBuffer.put(b, off, segment);
            off += segment;
            len -= remaining;
            if (this.currentBuffer.hasRemaining()) continue;
            this.flush();
        }
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("PacketOutputStream closed");
        }
        this.currentBuffer.flip();
        if (this.currentBuffer.remaining() > 0) {
            PlainDownPacket packet = new PlainDownPacket();
            packet.setBuffers(Collections.singleton(this.currentBuffer));
            try {
                this.down.sendDown(packet);
            }
            catch (ProtocolException e) {
                throw (IOException)new IOException().initCause(e);
            }
        }
        this.currentBuffer = ByteBuffer.allocate(this.packetSize);
    }

    public void close() throws IOException {
        this.flush();
        this.closed = true;
    }
}

