/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.network.protocol;

import EDU.oswego.cs.dl.util.concurrent.BoundedLinkedQueue;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.geronimo.network.protocol.DownPacket;
import org.apache.geronimo.network.protocol.Protocol;
import org.apache.geronimo.network.protocol.ProtocolException;
import org.apache.geronimo.network.protocol.UpPacket;

public class PacketInputStream
extends InputStream {
    ProtocolBuffer buffer;
    private final Protocol up;
    private ByteBuffer currentBuffer;
    private boolean closed;

    public PacketInputStream(Protocol up) {
        this(up, 1);
    }

    public PacketInputStream(Protocol up, short queueSize) {
        this.buffer = new ProtocolBuffer(queueSize);
        this.up = up;
        this.currentBuffer = ByteBuffer.allocate(0);
        this.closed = false;
        this.up.setUpProtocol(this.buffer);
        this.buffer.setDownProtocol(this.up);
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Packet InputStream closed");
        }
        this.check();
        return this.currentBuffer.get();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int segment;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int length = len; length > 0; length -= segment) {
            this.check();
            int remaining = this.currentBuffer.remaining();
            segment = Math.min(remaining, length);
            this.currentBuffer.get(b, off, segment);
            off += segment;
        }
        return len;
    }

    public long skip(long n) throws IOException {
        int segment;
        for (long length = n; length > 0L; length -= (long)segment) {
            segment = length <= Integer.MAX_VALUE ? Math.min(this.currentBuffer.remaining(), (int)length) : Math.min(this.currentBuffer.remaining(), Integer.MAX_VALUE);
            this.currentBuffer.position(this.currentBuffer.position() + segment);
            this.check();
        }
        return n;
    }

    public int available() throws IOException {
        return this.currentBuffer.remaining();
    }

    public void close() throws IOException {
        this.closed = true;
    }

    public synchronized void mark(int readlimit) {
    }

    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public boolean markSupported() {
        return false;
    }

    private void check() throws IOException {
        if (!this.currentBuffer.hasRemaining()) {
            try {
                this.currentBuffer = this.buffer.getPacket().getBuffer();
            }
            catch (InterruptedException e) {
                throw (IOException)new IOException().initCause(e);
            }
        }
    }

    private class ProtocolBuffer
    implements Protocol {
        BoundedLinkedQueue queue;
        Protocol down;

        ProtocolBuffer(short size) {
            this.queue = new BoundedLinkedQueue((int)size);
        }

        UpPacket getPacket() throws InterruptedException {
            return (UpPacket)this.queue.take();
        }

        public Protocol getUpProtocol() {
            throw new NoSuchMethodError("Socket protocol is at the bottom");
        }

        public void setUpProtocol(Protocol up) {
            throw new NoSuchMethodError("Socket protocol is at the bottom");
        }

        public Protocol getDownProtocol() {
            return this.down;
        }

        public void setDownProtocol(Protocol down) {
            this.down = down;
        }

        public void clearLinks() {
            this.down = null;
        }

        public Protocol cloneProtocol() throws CloneNotSupportedException {
            return (Protocol)super.clone();
        }

        public void setup() throws ProtocolException {
        }

        public void drain() throws ProtocolException {
        }

        public void teardown() throws ProtocolException {
        }

        public void sendUp(UpPacket packet) throws ProtocolException {
            try {
                this.queue.put((Object)packet);
            }
            catch (InterruptedException e) {
                throw new ProtocolException(e);
            }
        }

        public void sendDown(DownPacket packet) throws ProtocolException {
            throw new UnsupportedOperationException("Method not implemented");
        }
    }
}

