/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.network.protocol;

import java.util.Random;
import org.apache.geronimo.network.protocol.AbstractProtocol;
import org.apache.geronimo.network.protocol.DownPacket;
import org.apache.geronimo.network.protocol.ProtocolException;
import org.apache.geronimo.network.protocol.UpPacket;

public class LossyProtocol
extends AbstractProtocol {
    private final int STARTED = 0;
    private final int STOPPED = 1;
    private int state = 1;
    private Random upRandom = new Random();
    private Random downRandom = new Random();
    private float upLoss;
    private float downLoss;

    public float getUpLoss() {
        return this.upLoss;
    }

    public void setUpLoss(float upLoss) {
        if (this.state == 0) {
            throw new IllegalStateException("Protocol already started");
        }
        this.upLoss = upLoss;
    }

    public float getDownLoss() {
        return this.downLoss;
    }

    public void setDownLoss(float downLoss) {
        if (this.state == 0) {
            throw new IllegalStateException("Protocol already started");
        }
        this.downLoss = downLoss;
    }

    public void setup() throws ProtocolException {
        this.state = 0;
    }

    public void drain() throws ProtocolException {
        this.state = 1;
    }

    public void teardown() throws ProtocolException {
    }

    public void sendUp(UpPacket packet) throws ProtocolException {
        if (this.state == 1) {
            throw new IllegalStateException("Protocol is not started");
        }
        if (this.upRandom.nextFloat() > this.upLoss) {
            this.getUpProtocol().sendUp(packet);
        }
    }

    public void sendDown(DownPacket packet) throws ProtocolException {
        if (this.state == 1) {
            throw new IllegalStateException("Protocol is not started");
        }
        if (this.downRandom.nextFloat() > this.downLoss) {
            this.getDownProtocol().sendDown(packet);
        }
    }
}

