/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.network.protocol;

import EDU.oswego.cs.dl.util.concurrent.Latch;
import com.sun.security.jgss.GSSUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.network.protocol.AbstractProtocol;
import org.apache.geronimo.network.protocol.DownPacket;
import org.apache.geronimo.network.protocol.MetadataSupport;
import org.apache.geronimo.network.protocol.PlainDownPacket;
import org.apache.geronimo.network.protocol.Protocol;
import org.apache.geronimo.network.protocol.ProtocolException;
import org.apache.geronimo.network.protocol.UpPacket;
import org.apache.geronimo.network.protocol.control.BootstrapCook;
import org.apache.geronimo.network.protocol.control.ControlContext;
import org.apache.geronimo.network.protocol.control.commands.CreateInstanceMenuItem;
import org.apache.geronimo.network.protocol.control.commands.MenuItemPacketField;
import org.apache.geronimo.network.protocol.control.commands.SetAttributeMenuItem;
import org.apache.geronimo.network.protocol.control.commands.SetReferenceMenuItem;
import org.apache.geronimo.system.ThreadPool;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.MessageProp;

public class GSSAPIServerProtocol
extends AbstractProtocol
implements BootstrapCook {
    private static final Log log = LogFactory.getLog((Class)GSSAPIServerProtocol.class);
    private ThreadPool threadPool;
    private String serverNameString;
    private boolean mutualAuth;
    private boolean confidential;
    private boolean integrity;
    private GSSContext context;
    private Subject clientSubject;
    Latch startupLatch;

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public String getServerNameString() {
        return this.serverNameString;
    }

    public void setServerNameString(String serverNameString) {
        this.serverNameString = serverNameString;
    }

    public boolean isMutualAuth() {
        return this.mutualAuth;
    }

    public void setMutualAuth(boolean mutualAuth) {
        this.mutualAuth = mutualAuth;
    }

    public boolean isConfidential() {
        return this.confidential;
    }

    public void setConfidential(boolean confidential) {
        this.confidential = confidential;
    }

    public boolean isIntegrity() {
        return this.integrity;
    }

    public void setIntegrity(boolean integrity) {
        this.integrity = integrity;
    }

    public Protocol cloneProtocol() throws CloneNotSupportedException {
        GSSAPIServerProtocol result = (GSSAPIServerProtocol)super.clone();
        result.startupLatch = new Latch();
        try {
            GSSManager manager = GSSManager.getInstance();
            result.context = manager.createContext((GSSCredential)null);
            result.context.requestMutualAuth(this.mutualAuth);
            result.context.requestConf(this.confidential);
            result.context.requestInteg(this.integrity);
            result.context.requestCredDeleg(true);
        }
        catch (GSSException e) {
            throw new CloneNotSupportedException(e.toString());
        }
        return result;
    }

    public void setup() throws ProtocolException {
        log.trace((Object)"Starting");
    }

    public void drain() throws ProtocolException {
        log.trace((Object)"Stoping");
    }

    public void teardown() throws ProtocolException {
    }

    public void sendUp(UpPacket packet) throws ProtocolException {
        try {
            log.trace((Object)"sendUp");
            if (!this.context.isEstablished()) {
                ByteBuffer buffer = packet.getBuffer();
                byte[] token = this.context.acceptSecContext(buffer.array(), buffer.position(), buffer.remaining());
                PlainDownPacket reply = new PlainDownPacket();
                reply.setBuffers(Collections.singletonList(ByteBuffer.allocate(token.length).put(token).flip()));
                this.getDownProtocol().sendDown(reply);
                if (this.context.isEstablished()) {
                    log.trace((Object)"SECURE CONTEXT ESTABLISHED");
                    log.trace((Object)("Client is " + this.context.getSrcName()));
                    log.trace((Object)("Server is " + this.context.getTargName()));
                    if (this.context.getMutualAuthState()) {
                        log.trace((Object)"MUTUAL AUTHENTICATION IN PLACE");
                    }
                    if (this.context.getConfState()) {
                        log.trace((Object)"CONFIDENTIALITY IN PLACE");
                    }
                    if (this.context.getIntegState()) {
                        log.trace((Object)"INTEGRITY IN PLACE");
                    }
                    if (this.context.getCredDelegState()) {
                        log.trace((Object)"DELEGATE IN PLACE");
                        this.clientSubject = GSSUtil.createSubject(this.context.getSrcName(), this.context.getDelegCred());
                    } else {
                        this.clientSubject = new Subject();
                        KerberosPrincipal principal = new KerberosPrincipal(((Object)this.context.getSrcName()).toString());
                        this.clientSubject.getPrincipals().add(principal);
                    }
                    this.startupLatch.release();
                }
            } else {
                ByteBuffer buffer = packet.getBuffer();
                byte[] token = this.context.unwrap(buffer.array(), buffer.position(), buffer.remaining(), new MessageProp(0, true));
                UpPacket message = new UpPacket();
                message.setBuffer((ByteBuffer)ByteBuffer.allocate(token.length).put(token).flip());
                MetadataSupport.setSubject(message, this.clientSubject);
                this.getUpProtocol().sendUp(message);
            }
        }
        catch (GSSException e) {
            throw new ProtocolException(e);
        }
    }

    public void sendDown(DownPacket packet) throws ProtocolException {
        try {
            log.trace((Object)"sendDown");
            log.trace((Object)("AQUIRING " + this.startupLatch));
            if (!this.startupLatch.attempt(1000000L)) {
                throw new ProtocolException("Send timeout");
            }
            log.trace((Object)("AQUIRED " + this.startupLatch));
            int size = 0;
            Iterator iter = packet.getBuffers().iterator();
            while (iter.hasNext()) {
                size += ((ByteBuffer)iter.next()).remaining();
            }
            ByteBuffer buffer = ByteBuffer.allocate(size);
            Iterator iter2 = packet.getBuffers().iterator();
            while (iter2.hasNext()) {
                buffer.put((ByteBuffer)iter2.next());
            }
            buffer.flip();
            byte[] token = this.context.wrap(buffer.array(), buffer.position(), buffer.remaining(), new MessageProp(0, true));
            PlainDownPacket reply = new PlainDownPacket();
            reply.setBuffers(Collections.singletonList(ByteBuffer.allocate(token.length).put(token).flip()));
            this.getDownProtocol().sendDown(reply);
        }
        catch (GSSException e) {
            throw new ProtocolException(e);
        }
        catch (InterruptedException e) {
            throw new ProtocolException(e);
        }
    }

    public Collection cook(ControlContext context) {
        ArrayList<MenuItemPacketField> list = new ArrayList<MenuItemPacketField>(6);
        CreateInstanceMenuItem create = new CreateInstanceMenuItem();
        create.setClassName("org.apache.geronimo.network.protocol.GSSAPIClientProtocol");
        create.setInstanceId(context.assignId(this));
        list.add(create);
        SetAttributeMenuItem attribute = new SetAttributeMenuItem();
        attribute.setInstanceId(context.assignId(this));
        attribute.setAttributeName("ServerNameString");
        attribute.setAttributeValue(this.serverNameString);
        list.add(attribute);
        attribute = new SetAttributeMenuItem();
        attribute.setInstanceId(context.assignId(this));
        attribute.setAttributeName("MutualAuth");
        attribute.setAttributeValue(new Boolean(this.mutualAuth));
        list.add(attribute);
        attribute = new SetAttributeMenuItem();
        attribute.setInstanceId(context.assignId(this));
        attribute.setAttributeName("Confidential");
        attribute.setAttributeValue(new Boolean(this.confidential));
        list.add(attribute);
        attribute = new SetAttributeMenuItem();
        attribute.setInstanceId(context.assignId(this));
        attribute.setAttributeName("Integrity");
        attribute.setAttributeValue(new Boolean(this.integrity));
        list.add(attribute);
        SetReferenceMenuItem reference = new SetReferenceMenuItem();
        reference.setInstanceId(context.assignId(this));
        reference.setReferenceName("ThreadPool");
        reference.setReferenceId(context.assignId(this.threadPool));
        list.add(reference);
        return list;
    }
}

