/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.network;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBean;
import org.apache.geronimo.gbean.GBeanContext;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.WaitingException;
import org.apache.geronimo.network.SelectionEventListner;
import org.apache.geronimo.system.ThreadPool;

public class SelectorManager
implements Runnable,
GBean {
    private static final Log log = LogFactory.getLog((Class)SelectorManager.class);
    private ThreadPool threadPool;
    private volatile boolean running;
    private Object guard = new Object();
    private Selector selector;
    private long timeout;
    private ThreadGroup threadGroup = new ThreadGroup("Geronimo NIO Workers");
    private String threadName;
    private int startCounter;
    private static final GBeanInfo GBEAN_INFO;

    public SelectorManager() throws IOException {
        this.selector = Selector.open();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            log.debug((Object)"Selector Work thread has started.");
            log.debug((Object)("Selector Manager timeout: " + this.timeout));
            while (this.running) {
                Object object = this.guard;
                synchronized (object) {
                    log.trace((Object)"Waiting for selector to return.");
                }
                if (this.selector.select(this.timeout) == 0) continue;
                Set<SelectionKey> keys = this.selector.selectedKeys();
                Iterator<SelectionKey> i = keys.iterator();
                while (i.hasNext()) {
                    final SelectionKey key = i.next();
                    if (key.isReadable()) {
                        log.trace((Object)("-OP_READ " + key));
                        key.interestOps(key.interestOps() & 0xFFFFFFFE);
                    }
                    if (key.isWritable()) {
                        log.trace((Object)("-OP_WRITE " + key));
                        key.interestOps(key.interestOps() & 0xFFFFFFFB);
                    }
                    if (key.isAcceptable()) {
                        log.trace((Object)("-OP_ACCEPT " + key));
                        key.interestOps(key.interestOps() & 0xFFFFFFEF);
                    }
                    this.threadPool.getWorkManager().execute(new Runnable(){

                        public void run() {
                            try {
                                ((SelectionEventListner)key.attachment()).selectionEvent(key);
                            }
                            catch (Throwable e) {
                                log.trace((Object)"Request Failed.", e);
                            }
                        }
                    });
                    i.remove();
                }
            }
        }
        catch (CancelledKeyException e) {
            log.debug((Object)("Key has Been Cancelled: " + e));
        }
        catch (IOException e) {
            log.warn((Object)"IOException occured.", (Throwable)e);
        }
        catch (InterruptedException e) {
            log.debug((Object)"Selector Work thread has been interrupted.");
        }
        finally {
            log.debug((Object)"Selector Work thread has stopped.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectionKey register(SelectableChannel selectableChannel, int ops, SelectionEventListner listener) throws ClosedChannelException {
        Object object = this.guard;
        synchronized (object) {
            this.selector.wakeup();
            SelectionKey key = selectableChannel.register(this.selector, ops, listener);
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInterestOps(SelectionKey selectorKey, int addOpts) {
        Object object = this.guard;
        synchronized (object) {
            this.selector.wakeup();
            selectorKey.interestOps(selectorKey.interestOps() | addOpts);
        }
    }

    public void setGBeanContext(GBeanContext context) {
    }

    public void doStart() throws WaitingException, Exception {
        ++this.startCounter;
        if (this.startCounter == 1) {
            log.debug((Object)"Starting a Selector Work thread.");
            this.running = true;
            new Thread(this.threadGroup, this, this.threadName).start();
        }
    }

    public void doStop() throws WaitingException, Exception {
        --this.startCounter;
        if (this.startCounter == 0) {
            log.debug((Object)"Stopping a Selector Work thread.");
            this.running = false;
            this.selector.wakeup();
        }
    }

    public void doFail() {
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoFactory infoFactory = new GBeanInfoFactory(SelectorManager.class.getName());
        infoFactory.addAttribute("Timeout", true);
        infoFactory.addAttribute("ThreadPool", true);
        infoFactory.addAttribute("ThreadName", true);
        infoFactory.addOperation("getSelector");
        infoFactory.addOperation("getStartCounter");
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

