/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.network;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import org.apache.geronimo.kernel.ClassLoading;
import org.apache.geronimo.network.TransportContext;

public class ResolvingObjectInputStream
extends ObjectInputStream {
    private ClassLoader classLoader;
    private TransportContext transportContext;

    public ResolvingObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
        this(in, classLoader, null);
    }

    public ResolvingObjectInputStream(InputStream in, ClassLoader classLoader, TransportContext transportContext) throws IOException {
        super(in);
        this.classLoader = classLoader;
        this.transportContext = transportContext;
        this.enableResolveObject(transportContext != null);
    }

    protected Class resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        return ClassLoading.loadClass((String)classDesc.getName(), (ClassLoader)this.classLoader);
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class[] cinterfaces = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            cinterfaces[i] = this.classLoader.loadClass(interfaces[i]);
        }
        try {
            return Proxy.getProxyClass(this.classLoader, cinterfaces);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }

    protected Object resolveObject(Object obj) throws IOException {
        return this.transportContext.readReplace(obj);
    }
}

