/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.deployment;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.transaction.UserTransaction;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.common.UnresolvedReferenceException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.RefContext;
import org.apache.geronimo.j2ee.deployment.ServiceReferenceBuilder;
import org.apache.geronimo.kernel.ClassLoading;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.naming.deployment.ResourceEnvironmentBuilder;
import org.apache.geronimo.naming.java.ComponentContextBuilder;
import org.apache.geronimo.naming.reference.GBeanReference;
import org.apache.geronimo.xbeans.geronimo.naming.GerEjbLocalRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerEjbRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerGbeanLocatorType;
import org.apache.geronimo.xbeans.geronimo.naming.GerGbeanRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerMessageDestinationType;
import org.apache.geronimo.xbeans.geronimo.naming.GerPatternType;
import org.apache.geronimo.xbeans.geronimo.naming.GerResourceEnvRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerResourceRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerServiceRefType;
import org.apache.geronimo.xbeans.j2ee.EjbLocalRefType;
import org.apache.geronimo.xbeans.j2ee.EjbRefType;
import org.apache.geronimo.xbeans.j2ee.EnvEntryType;
import org.apache.geronimo.xbeans.j2ee.MessageDestinationRefType;
import org.apache.geronimo.xbeans.j2ee.MessageDestinationType;
import org.apache.geronimo.xbeans.j2ee.ParamValueType;
import org.apache.geronimo.xbeans.j2ee.PortComponentRefType;
import org.apache.geronimo.xbeans.j2ee.ResourceEnvRefType;
import org.apache.geronimo.xbeans.j2ee.ResourceRefType;
import org.apache.geronimo.xbeans.j2ee.ServiceRefHandlerType;
import org.apache.geronimo.xbeans.j2ee.ServiceRefType;
import org.apache.geronimo.xbeans.j2ee.XsdQNameType;
import org.apache.geronimo.xbeans.j2ee.XsdStringType;

public class ENCConfigBuilder {
    private static final String JAXR_CONNECTION_FACTORY_CLASS = "javax.xml.registry.ConnectionFactory";
    static /* synthetic */ Class class$java$net$URL;

    public static void registerMessageDestinations(RefContext refContext, String moduleName, MessageDestinationType[] specDestinations, GerMessageDestinationType[] destinations) throws DeploymentException {
        HashMap<String, GerMessageDestinationType> nameMap = new HashMap<String, GerMessageDestinationType>();
        for (int i = 0; i < destinations.length; ++i) {
            GerMessageDestinationType destination = destinations[i];
            String name = destination.getMessageDestinationName().trim();
            nameMap.put(name, destination);
            boolean found = false;
            for (int j = 0; j < specDestinations.length; ++j) {
                MessageDestinationType specDestination = specDestinations[j];
                if (!specDestination.getMessageDestinationName().getStringValue().trim().equals(name)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new DeploymentException("No spec DD message-destination for " + name);
        }
        refContext.registerMessageDestionations(moduleName, nameMap);
    }

    public static AbstractNameQuery getGBeanQuery(String j2eeType, GerGbeanLocatorType gerGbeanLocator) {
        AbstractNameQuery abstractNameQuery;
        if (gerGbeanLocator.isSetGbeanLink()) {
            String linkName = gerGbeanLocator.getGbeanLink().trim();
            abstractNameQuery = ENCConfigBuilder.buildAbstractNameQuery(null, null, linkName, j2eeType, null);
        } else {
            GerPatternType patternType = gerGbeanLocator.getPattern();
            abstractNameQuery = ENCConfigBuilder.buildAbstractNameQuery(patternType, j2eeType, null, null);
        }
        return abstractNameQuery;
    }

    static void addEnvEntries(EnvEntryType[] envEntries, ComponentContextBuilder builder, ClassLoader classLoader) throws DeploymentException {
        for (int i = 0; i < envEntries.length; ++i) {
            EnvEntryType envEntry = envEntries[i];
            String name = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)envEntry.getEnvEntryName());
            String type = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)envEntry.getEnvEntryType());
            String text = ENCConfigBuilder.getStringValue(envEntry.getEnvEntryValue());
            try {
                builder.addEnvEntry(name, type, text, classLoader);
                continue;
            }
            catch (NumberFormatException e) {
                throw new DeploymentException("Invalid env-entry value for name: " + name, (Throwable)e);
            }
            catch (NamingException e) {
                throw new DeploymentException("Invalid env-entry definition for name: " + name, (Throwable)e);
            }
        }
    }

    static void addResourceRefs(Configuration earContext, RefContext refContext, ResourceRefType[] resourceRefs, Map refMap, ClassLoader cl, ComponentContextBuilder builder) throws DeploymentException {
        if (refMap == null) {
            refMap = Collections.EMPTY_MAP;
        }
        HashMap newMap = new HashMap();
        Iterator it = refMap.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            newMap.put(name.trim(), refMap.get(name));
        }
        refMap = newMap;
        for (int i = 0; i < resourceRefs.length; ++i) {
            Class<?> iface;
            ResourceRefType resourceRef = resourceRefs[i];
            String name = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)resourceRef.getResRefName());
            String type = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)resourceRef.getResType());
            GerResourceRefType gerResourceRef = (GerResourceRefType)refMap.get(name);
            try {
                iface = cl.loadClass(type);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("could not load class " + type, (Throwable)e);
            }
            if (iface == (class$java$net$URL == null ? ENCConfigBuilder.class$("java.net.URL") : class$java$net$URL)) {
                if (gerResourceRef == null || !gerResourceRef.isSetUrl()) {
                    throw new DeploymentException("No url supplied to resolve: " + name);
                }
                try {
                    builder.bind(name, (Object)new URL(gerResourceRef.getUrl()));
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new DeploymentException("Could not convert " + gerResourceRef.getUrl() + " to URL", (Throwable)e);
                }
            }
            String j2eeType = "javax.mail.Session".equals(type) ? "JavaMailResource" : (JAXR_CONNECTION_FACTORY_CLASS.equals(type) ? "JAXRConnectionFactory" : "JCAManagedConnectionFactory");
            try {
                AbstractNameQuery containerId = ENCConfigBuilder.getResourceContainerId(name, j2eeType, null, gerResourceRef);
                Reference ref = refContext.getConnectionFactoryRef(containerId, iface, earContext);
                builder.bind(name, (Object)ref);
                continue;
            }
            catch (UnresolvedReferenceException e) {
                StringBuffer errorMessage = new StringBuffer("Unable to resolve resource reference '");
                errorMessage.append(name);
                errorMessage.append("' (");
                if (e.isMultiple()) {
                    errorMessage.append("Found multiple matching resources.  Try being more specific in a resource-ref mapping in your Geronimo deployment plan.");
                } else if (gerResourceRef == null) {
                    errorMessage.append("Could not auto-map to resource.  Try adding a resource-ref mapping to your Geronimo deployment plan.");
                } else if (gerResourceRef.isSetResourceLink()) {
                    errorMessage.append("Could not find resource '");
                    errorMessage.append(gerResourceRef.getResourceLink());
                    errorMessage.append("'.  Perhaps it has not yet been configured, or your application does not have a dependency declared for that resource module?");
                } else {
                    errorMessage.append("Could not find the resource specified in your Geronimo deployment plan:");
                    errorMessage.append(gerResourceRef.getPattern());
                }
                errorMessage.append(")");
                throw new DeploymentException(errorMessage.toString());
            }
        }
    }

    private static AbstractNameQuery getResourceContainerId(String name, String type, URI moduleURI, GerResourceRefType gerResourceRef) {
        AbstractNameQuery containerId;
        String module;
        String string = module = moduleURI == null ? null : moduleURI.toString();
        if (gerResourceRef == null) {
            containerId = ENCConfigBuilder.buildAbstractNameQuery(null, module, name, type, "ResourceAdapterModule");
        } else if (gerResourceRef.isSetResourceLink()) {
            containerId = ENCConfigBuilder.buildAbstractNameQuery(null, module, gerResourceRef.getResourceLink().trim(), type, "ResourceAdapterModule");
        } else {
            GerPatternType patternType = gerResourceRef.getPattern();
            containerId = ENCConfigBuilder.buildAbstractNameQuery(patternType, type, "ResourceAdapterModule", null);
        }
        return containerId;
    }

    static void addResourceEnvRefs(Configuration earContext, RefContext refContext, ResourceEnvRefType[] resourceEnvRefArray, Map refMap, ClassLoader cl, ComponentContextBuilder builder) throws DeploymentException {
        if (refMap == null) {
            refMap = Collections.EMPTY_MAP;
        }
        HashMap newMap = new HashMap();
        Iterator it = refMap.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            newMap.put(name.trim(), refMap.get(name));
        }
        refMap = newMap;
        for (int i = 0; i < resourceEnvRefArray.length; ++i) {
            Class<?> iface;
            ResourceEnvRefType resourceEnvRef = resourceEnvRefArray[i];
            String name = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)resourceEnvRef.getResourceEnvRefName());
            String type = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)resourceEnvRef.getResourceEnvRefType());
            try {
                iface = cl.loadClass(type);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("could not load class " + type, (Throwable)e);
            }
            GerResourceEnvRefType gerResourceEnvRef = (GerResourceEnvRefType)refMap.get(name);
            try {
                AbstractNameQuery containerId = ENCConfigBuilder.getAdminObjectContainerId(name, gerResourceEnvRef);
                Reference ref = refContext.getAdminObjectRef(containerId, iface, earContext);
                builder.bind(name, (Object)ref);
                continue;
            }
            catch (UnresolvedReferenceException e) {
                throw new DeploymentException("Unable to resolve resource env reference '" + name + "' (" + (e.isMultiple() ? "found multiple matching resources" : "no matching resources found") + ")");
            }
        }
    }

    private static AbstractNameQuery getAdminObjectContainerId(String name, GerResourceEnvRefType gerResourceEnvRef) {
        AbstractNameQuery containerId;
        if (gerResourceEnvRef == null) {
            containerId = ENCConfigBuilder.buildAbstractNameQuery(null, null, name, "JCAAdminObject", "ResourceAdapterModule");
        } else if (gerResourceEnvRef.isSetMessageDestinationLink()) {
            containerId = ENCConfigBuilder.buildAbstractNameQuery(null, null, gerResourceEnvRef.getMessageDestinationLink().trim(), "JCAAdminObject", "ResourceAdapterModule");
        } else if (gerResourceEnvRef.isSetAdminObjectLink()) {
            String moduleURI = null;
            if (gerResourceEnvRef.isSetAdminObjectModule()) {
                moduleURI = gerResourceEnvRef.getAdminObjectModule().trim();
            }
            containerId = ENCConfigBuilder.buildAbstractNameQuery(null, moduleURI, gerResourceEnvRef.getAdminObjectLink().trim(), "JCAAdminObject", "ResourceAdapterModule");
        } else {
            GerPatternType patternType = gerResourceEnvRef.getPattern();
            containerId = ENCConfigBuilder.buildAbstractNameQuery(patternType, "JCAAdminObject", "ResourceAdapterModule", null);
        }
        return containerId;
    }

    static void addMessageDestinationRefs(Configuration earContext, RefContext refContext, MessageDestinationRefType[] messageDestinationRefs, ClassLoader cl, ComponentContextBuilder builder) throws DeploymentException {
        for (int i = 0; i < messageDestinationRefs.length; ++i) {
            Class<?> iface;
            MessageDestinationRefType messageDestinationRef = messageDestinationRefs[i];
            String name = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)messageDestinationRef.getMessageDestinationRefName());
            String linkName = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)messageDestinationRef.getMessageDestinationLink());
            String type = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)messageDestinationRef.getMessageDestinationType());
            try {
                iface = cl.loadClass(type);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("could not load class " + type, (Throwable)e);
            }
            String moduleURI = null;
            GerMessageDestinationType destination = (GerMessageDestinationType)refContext.getMessageDestination(linkName);
            if (destination != null) {
                if (destination.isSetAdminObjectLink()) {
                    if (destination.isSetAdminObjectModule()) {
                        moduleURI = destination.getAdminObjectModule().trim();
                    }
                    linkName = destination.getAdminObjectLink().trim();
                }
            } else {
                int pos = linkName.indexOf(35);
                if (pos > -1) {
                    linkName = linkName.substring(pos + 1);
                }
            }
            AbstractNameQuery containerId = ENCConfigBuilder.buildAbstractNameQuery(null, moduleURI, linkName, "JCAAdminObject", "ResourceAdapterModule");
            Reference ref = refContext.getAdminObjectRef(containerId, iface, earContext);
            builder.bind(name, (Object)ref);
        }
    }

    static void addEJBRefs(Configuration earContext, Configuration ejbContext, RefContext refContext, URI moduleURI, EjbRefType[] ejbRefs, Map ejbRefMap, ClassLoader cl, ComponentContextBuilder builder) throws DeploymentException {
        HashMap newMap = new HashMap();
        Iterator it = ejbRefMap.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            newMap.put(name.trim(), ejbRefMap.get(name));
        }
        ejbRefMap = newMap;
        for (int i = 0; i < ejbRefs.length; ++i) {
            EjbRefType ejbRef = ejbRefs[i];
            String ejbRefName = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbRef.getEjbRefName());
            GerEjbRefType remoteRef = (GerEjbRefType)ejbRefMap.get(ejbRefName);
            Reference ejbReference = ENCConfigBuilder.addEJBRef(earContext, ejbContext, refContext, moduleURI, ejbRef, remoteRef, cl);
            builder.bind(ejbRefName, (Object)ejbReference);
        }
    }

    static Reference addEJBRef(Configuration earContext, Configuration ejbContext, RefContext refContext, URI moduleURI, EjbRefType ejbRef, GerEjbRefType remoteRef, ClassLoader cl) throws DeploymentException {
        Reference ejbReference;
        String remote = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbRef.getRemote());
        String refName = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbRef.getEjbRefName());
        try {
            ENCConfigBuilder.assureEJBObjectInterface(remote, cl);
        }
        catch (DeploymentException e) {
            throw new DeploymentException("Error processing 'remote' element for EJB Reference '" + refName + "' for module '" + moduleURI + "': " + e.getMessage());
        }
        String home = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbRef.getHome());
        try {
            ENCConfigBuilder.assureEJBHomeInterface(home, cl);
        }
        catch (DeploymentException e) {
            throw new DeploymentException("Error processing 'home' element for EJB Reference '" + refName + "' for module '" + moduleURI + "': " + e.getMessage());
        }
        boolean isSession = "Session".equals(ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbRef.getEjbRefType()));
        if (isSession && remote.equals("javax.management.j2ee.Management") && home.equals("javax.management.j2ee.ManagementHome")) {
            AbstractNameQuery query = new AbstractNameQuery(null, Collections.singletonMap("name", "ejb/mgmt/MEJB"));
            ejbReference = refContext.getEJBRemoteRef(null, ejbContext, null, null, null, null, query, isSession, home, remote);
        } else {
            String ejbLink = null;
            if (remoteRef != null && remoteRef.isSetNsCorbaloc()) {
                try {
                    AbstractNameQuery cssBean;
                    if (remoteRef.isSetCssLink()) {
                        String cssLink = remoteRef.getCssLink().trim();
                        cssBean = ENCConfigBuilder.buildAbstractNameQuery(null, null, cssLink, "CORBACSS", "EJBModule");
                    } else {
                        GerPatternType css = remoteRef.getCss();
                        cssBean = ENCConfigBuilder.buildAbstractNameQuery(css, "CORBACSS", "EJBModule", null);
                    }
                    ejbReference = refContext.getCORBARemoteRef(earContext, cssBean, new URI(ENCConfigBuilder.getStringValue(remoteRef.getNsCorbaloc())), ENCConfigBuilder.getStringValue(remoteRef.getName()), home);
                }
                catch (URISyntaxException e) {
                    throw new DeploymentException("Could not construct CORBA NameServer URI: " + remoteRef.getNsCorbaloc(), (Throwable)e);
                }
            } else {
                Artifact targetConfigId = null;
                String optionalModule = moduleURI == null ? null : moduleURI.toString();
                String requiredModule = null;
                AbstractNameQuery containerQuery = null;
                if (remoteRef != null && remoteRef.isSetEjbLink()) {
                    ejbLink = remoteRef.getEjbLink();
                } else if (ejbRef.isSetEjbLink()) {
                    ejbLink = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbRef.getEjbLink());
                    targetConfigId = ejbContext.getId();
                }
                if (ejbLink != null) {
                    String[] bits = ejbLink.split("#");
                    if (bits.length == 2) {
                        requiredModule = bits[0];
                        if (moduleURI != null) {
                            requiredModule = moduleURI.resolve(requiredModule).getPath();
                        }
                        ejbLink = bits[1];
                    }
                } else if (remoteRef != null) {
                    GerPatternType patternType = remoteRef.getPattern();
                    containerQuery = ENCConfigBuilder.buildAbstractNameQuery(patternType, null, "EJBModule", null);
                }
                ejbReference = refContext.getEJBRemoteRef(refName, ejbContext, ejbLink, requiredModule, optionalModule, targetConfigId, containerQuery, isSession, home, remote);
            }
        }
        return ejbReference;
    }

    static void addEJBLocalRefs(Configuration ejbContext, RefContext refContext, URI moduleURI, EjbLocalRefType[] ejbLocalRefs, Map ejbLocalRefMap, ClassLoader cl, ComponentContextBuilder builder) throws DeploymentException {
        HashMap newMap = new HashMap();
        Iterator it = ejbLocalRefMap.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            newMap.put(name.trim(), ejbLocalRefMap.get(name));
        }
        ejbLocalRefMap = newMap;
        for (int i = 0; i < ejbLocalRefs.length; ++i) {
            EjbLocalRefType ejbLocalRef = ejbLocalRefs[i];
            String ejbRefName = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbLocalRef.getEjbRefName());
            GerEjbLocalRefType localRef = (GerEjbLocalRefType)ejbLocalRefMap.get(ejbRefName);
            Reference ejbReference = ENCConfigBuilder.addEJBLocalRef(ejbContext, refContext, moduleURI, ejbLocalRef, localRef, cl);
            builder.bind(ejbRefName, (Object)ejbReference);
        }
    }

    static Reference addEJBLocalRef(Configuration ejbContext, RefContext refContext, URI moduleURI, EjbLocalRefType ejbLocalRef, GerEjbLocalRefType localRef, ClassLoader cl) throws DeploymentException {
        String local = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbLocalRef.getLocal());
        String refName = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbLocalRef.getEjbRefName());
        try {
            ENCConfigBuilder.assureEJBLocalObjectInterface(local, cl);
        }
        catch (DeploymentException e) {
            throw new DeploymentException("Error processing 'local' element for EJB Local Reference '" + refName + "' for module '" + moduleURI + "': " + e.getMessage());
        }
        String localHome = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbLocalRef.getLocalHome());
        try {
            ENCConfigBuilder.assureEJBLocalHomeInterface(localHome, cl);
        }
        catch (DeploymentException e) {
            throw new DeploymentException("Error processing 'local-home' element for EJB Local Reference '" + refName + "' for module '" + moduleURI + "': " + e.getMessage());
        }
        boolean isSession = "Session".equals(ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbLocalRef.getEjbRefType()));
        String ejbLink = null;
        if (localRef != null && localRef.isSetEjbLink()) {
            ejbLink = localRef.getEjbLink();
        } else if (ejbLocalRef.isSetEjbLink()) {
            ejbLink = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbLocalRef.getEjbLink());
        }
        Artifact targetConfigId = null;
        String optionalModule = moduleURI == null ? null : moduleURI.toString();
        String requiredModule = null;
        AbstractNameQuery containerQuery = null;
        if (localRef != null && localRef.isSetEjbLink()) {
            ejbLink = localRef.getEjbLink();
        } else if (ejbLocalRef.isSetEjbLink()) {
            ejbLink = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbLocalRef.getEjbLink());
            targetConfigId = ejbContext.getId();
        }
        if (ejbLink != null) {
            String[] bits = ejbLink.split("#");
            if (bits.length == 2) {
                requiredModule = bits[0];
                ejbLink = bits[1];
            }
        } else if (localRef != null) {
            GerPatternType patternType = localRef.getPattern();
            containerQuery = ENCConfigBuilder.buildAbstractNameQuery(patternType, null, "EJBModule", null);
        }
        return refContext.getEJBLocalRef(refName, ejbContext, ejbLink, requiredModule, optionalModule, targetConfigId, containerQuery, isSession, localHome, local);
    }

    static void addServiceRefs(EARContext earContext, Module module, ServiceRefType[] serviceRefs, Map serviceRefMap, ClassLoader cl, ComponentContextBuilder builder) throws DeploymentException {
        HashMap newMap = new HashMap();
        Iterator it = serviceRefMap.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            newMap.put(name.trim(), serviceRefMap.get(name));
        }
        serviceRefMap = newMap;
        RefContext refContext = earContext.getRefContext();
        for (int i = 0; i < serviceRefs.length; ++i) {
            Class<?> serviceInterface;
            ServiceRefType serviceRef = serviceRefs[i];
            String name = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)serviceRef.getServiceRefName());
            GerServiceRefType serviceRefType = (GerServiceRefType)serviceRefMap.get(name);
            String serviceInterfaceName = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)serviceRef.getServiceInterface());
            ENCConfigBuilder.assureInterface(serviceInterfaceName, "javax.xml.rpc.Service", "[Web]Service", cl);
            try {
                serviceInterface = cl.loadClass(serviceInterfaceName);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Could not load service interface class: " + serviceInterfaceName, (Throwable)e);
            }
            URI wsdlURI = null;
            if (serviceRef.isSetWsdlFile()) {
                try {
                    wsdlURI = new URI(ENCConfigBuilder.getStringValue(serviceRef.getWsdlFile().getStringValue()));
                }
                catch (URISyntaxException e) {
                    throw new DeploymentException("could not construct wsdl uri from " + serviceRef.getWsdlFile().getStringValue(), (Throwable)e);
                }
            }
            URI jaxrpcMappingURI = null;
            if (serviceRef.isSetJaxrpcMappingFile()) {
                try {
                    jaxrpcMappingURI = new URI(ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)serviceRef.getJaxrpcMappingFile()));
                }
                catch (URISyntaxException e) {
                    throw new DeploymentException("Could not construct jaxrpc mapping uri from " + serviceRef.getJaxrpcMappingFile(), (Throwable)e);
                }
            }
            QName serviceQName = null;
            if (serviceRef.isSetServiceQname()) {
                serviceQName = serviceRef.getServiceQname().getQNameValue();
            }
            HashMap portComponentRefMap = new HashMap();
            PortComponentRefType[] portComponentRefs = serviceRef.getPortComponentRefArray();
            if (portComponentRefs != null) {
                for (int j = 0; j < portComponentRefs.length; ++j) {
                    Class<?> serviceEndpointClass;
                    PortComponentRefType portComponentRef = portComponentRefs[j];
                    String portComponentLink = ENCConfigBuilder.getStringValue(portComponentRef.getPortComponentLink());
                    String serviceEndpointInterfaceType = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)portComponentRef.getServiceEndpointInterface());
                    ENCConfigBuilder.assureInterface(serviceEndpointInterfaceType, "java.rmi.Remote", "ServiceEndpoint", cl);
                    try {
                        serviceEndpointClass = cl.loadClass(serviceEndpointInterfaceType);
                    }
                    catch (ClassNotFoundException e) {
                        throw new DeploymentException("could not load service endpoint class " + serviceEndpointInterfaceType, (Throwable)e);
                    }
                    portComponentRefMap.put(serviceEndpointClass, portComponentLink);
                }
            }
            ServiceRefHandlerType[] handlers = serviceRef.getHandlerArray();
            List handlerInfos = ENCConfigBuilder.buildHandlerInfoList(handlers, cl);
            Object ref = refContext.getServiceReference(serviceInterface, wsdlURI, jaxrpcMappingURI, serviceQName, portComponentRefMap, handlerInfos, (Object)serviceRefType, (DeploymentContext)earContext, module, cl);
            builder.bind(name, ref);
        }
    }

    private static List buildHandlerInfoList(ServiceRefHandlerType[] handlers, ClassLoader classLoader) throws DeploymentException {
        ArrayList<ServiceReferenceBuilder.HandlerInfoInfo> handlerInfos = new ArrayList<ServiceReferenceBuilder.HandlerInfoInfo>();
        for (int i = 0; i < handlers.length; ++i) {
            Class handlerClass;
            ServiceRefHandlerType handler = handlers[i];
            org.apache.geronimo.xbeans.j2ee.String[] portNameArray = handler.getPortNameArray();
            ArrayList<String> portNames = new ArrayList<String>();
            for (int j = 0; j < portNameArray.length; ++j) {
                portNames.add(portNameArray[j].getStringValue().trim());
            }
            String handlerClassName = handler.getHandlerClass().getStringValue().trim();
            try {
                handlerClass = ClassLoading.loadClass((String)handlerClassName, (ClassLoader)classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Could not load handler class", (Throwable)e);
            }
            HashMap<String, String> config = new HashMap<String, String>();
            ParamValueType[] paramValues = handler.getInitParamArray();
            for (int j = 0; j < paramValues.length; ++j) {
                ParamValueType paramValue = paramValues[j];
                String paramName = paramValue.getParamName().getStringValue().trim();
                String paramStringValue = paramValue.getParamValue().getStringValue().trim();
                config.put(paramName, paramStringValue);
            }
            XsdQNameType[] soapHeaderQNames = handler.getSoapHeaderArray();
            QName[] headerQNames = new QName[soapHeaderQNames.length];
            for (int j = 0; j < soapHeaderQNames.length; ++j) {
                XsdQNameType soapHeaderQName = soapHeaderQNames[j];
                headerQNames[j] = soapHeaderQName.getQNameValue();
            }
            HashSet<String> soapRoles = new HashSet<String>();
            for (int j = 0; j < handler.getSoapRoleArray().length; ++j) {
                String soapRole = handler.getSoapRoleArray(j).getStringValue().trim();
                soapRoles.add(soapRole);
            }
            ServiceReferenceBuilder.HandlerInfoInfo handlerInfoInfo = new ServiceReferenceBuilder.HandlerInfoInfo(new HashSet(portNames), handlerClass, config, headerQNames, soapRoles);
            handlerInfos.add(handlerInfoInfo);
        }
        return handlerInfos;
    }

    public static Class assureEJBObjectInterface(String remote, ClassLoader cl) throws DeploymentException {
        return ENCConfigBuilder.assureInterface(remote, "javax.ejb.EJBObject", "Remote", cl);
    }

    public static Class assureEJBHomeInterface(String home, ClassLoader cl) throws DeploymentException {
        return ENCConfigBuilder.assureInterface(home, "javax.ejb.EJBHome", "Home", cl);
    }

    public static Class assureEJBLocalObjectInterface(String local, ClassLoader cl) throws DeploymentException {
        return ENCConfigBuilder.assureInterface(local, "javax.ejb.EJBLocalObject", "Local", cl);
    }

    public static Class assureEJBLocalHomeInterface(String localHome, ClassLoader cl) throws DeploymentException {
        return ENCConfigBuilder.assureInterface(localHome, "javax.ejb.EJBLocalHome", "LocalHome", cl);
    }

    public static Class assureInterface(String interfaceName, String superInterfaceName, String interfaceType, ClassLoader cl) throws DeploymentException {
        Class<?> superInterface;
        Class<?> clazz;
        if (interfaceName == null || interfaceName.equals("")) {
            throw new DeploymentException("interface name cannot be blank");
        }
        try {
            clazz = cl.loadClass(interfaceName);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException(interfaceType + " interface class not found: " + interfaceName);
        }
        if (!clazz.isInterface()) {
            throw new DeploymentException(interfaceType + " interface is not an interface: " + interfaceName);
        }
        try {
            superInterface = cl.loadClass(superInterfaceName);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Class " + superInterfaceName + " could not be loaded");
        }
        if (!superInterface.isAssignableFrom(clazz)) {
            throw new DeploymentException(interfaceType + " interface does not extend " + superInterfaceName + ": " + interfaceName);
        }
        return clazz;
    }

    private static String getStringValue(org.apache.geronimo.xbeans.j2ee.String string) {
        if (string == null) {
            return null;
        }
        String s = string.getStringValue();
        return s == null ? null : s.trim();
    }

    private static String getStringValue(XsdStringType string) {
        if (string == null) {
            return null;
        }
        String s = string.getStringValue();
        return s == null ? null : s.trim();
    }

    private static String getStringValue(String string) {
        return string == null ? null : string.trim();
    }

    public static void setResourceEnvironment(ResourceEnvironmentBuilder builder, ResourceRefType[] resourceRefs, GerResourceRefType[] gerResourceRefs) {
        Map refMap = ENCConfigBuilder.mapResourceRefs(gerResourceRefs);
        HashSet<AbstractNameQuery> unshareableResources = new HashSet<AbstractNameQuery>();
        HashSet<AbstractNameQuery> applicationManagedSecurityResources = new HashSet<AbstractNameQuery>();
        for (int i = 0; i < resourceRefs.length; ++i) {
            ResourceRefType resourceRefType = resourceRefs[i];
            String type = resourceRefType.getResType().getStringValue().trim();
            if ((class$java$net$URL == null ? ENCConfigBuilder.class$("java.net.URL") : class$java$net$URL).getName().equals(type) || "javax.mail.Session".equals(type) || JAXR_CONNECTION_FACTORY_CLASS.equals(type)) continue;
            GerResourceRefType gerResourceRef = (GerResourceRefType)refMap.get(resourceRefType.getResRefName().getStringValue());
            AbstractNameQuery containerId = ENCConfigBuilder.getResourceContainerId(ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)resourceRefType.getResRefName()), "JCAManagedConnectionFactory", null, gerResourceRef);
            if ("Unshareable".equals(ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)resourceRefType.getResSharingScope()))) {
                unshareableResources.add(containerId);
            }
            if (!"Application".equals(ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)resourceRefType.getResAuth()))) continue;
            applicationManagedSecurityResources.add(containerId);
        }
        builder.setUnshareableResources(unshareableResources);
        builder.setApplicationManagedSecurityResources(applicationManagedSecurityResources);
    }

    public static Map buildComponentContext(EARContext earContext, Configuration ejbContext, Module module, UserTransaction userTransaction, EnvEntryType[] envEntries, EjbRefType[] ejbRefs, GerEjbRefType[] gerEjbRefs, EjbLocalRefType[] ejbLocalRefs, GerEjbLocalRefType[] gerEjbLocalRef, ResourceRefType[] resourceRefs, GerResourceRefType[] gerResourceRef, ResourceEnvRefType[] resourceEnvRefs, GerResourceEnvRefType[] gerResourceEnvRef, MessageDestinationRefType[] messageDestinationRefs, ServiceRefType[] serviceRefs, GerServiceRefType[] gerServiceRefs, GerGbeanRefType[] gerGbeanRefs, ClassLoader cl) throws DeploymentException {
        AbstractNameQuery corbaGBean;
        ComponentContextBuilder builder = new ComponentContextBuilder();
        RefContext refContext = earContext.getRefContext();
        Configuration earConfiguration = earContext.getConfiguration();
        if (userTransaction != null) {
            builder.addUserTransaction(userTransaction);
        }
        if ((corbaGBean = earContext.getCORBAGBeanObjectName()) != null) {
            builder.addORB(earConfiguration.getId(), corbaGBean);
            builder.addHandleDelegateReference(earConfiguration.getId(), corbaGBean);
        }
        URI moduleURI = module.getModuleURI();
        ENCConfigBuilder.addEnvEntries(envEntries, builder, cl);
        if (ejbContext == null) {
            ejbContext = earConfiguration;
        }
        ENCConfigBuilder.addEJBRefs(earConfiguration, ejbContext, refContext, moduleURI, ejbRefs, ENCConfigBuilder.mapEjbRefs(gerEjbRefs), cl, builder);
        ENCConfigBuilder.addEJBLocalRefs(ejbContext, refContext, moduleURI, ejbLocalRefs, ENCConfigBuilder.mapEjbLocalRefs(gerEjbLocalRef), cl, builder);
        ENCConfigBuilder.addResourceRefs(earConfiguration, refContext, resourceRefs, ENCConfigBuilder.mapResourceRefs(gerResourceRef), cl, builder);
        ENCConfigBuilder.addResourceEnvRefs(earConfiguration, refContext, resourceEnvRefs, ENCConfigBuilder.mapResourceEnvRefs(gerResourceEnvRef), cl, builder);
        ENCConfigBuilder.addMessageDestinationRefs(earConfiguration, refContext, messageDestinationRefs, cl, builder);
        Map serviceRefMap = ENCConfigBuilder.mapServiceRefs(gerServiceRefs);
        ENCConfigBuilder.addServiceRefs(earContext, module, serviceRefs, serviceRefMap, cl, builder);
        ENCConfigBuilder.addGBeanRefs(earContext, builder, refContext, gerGbeanRefs, cl);
        return builder.getContext();
    }

    private static void addGBeanRefs(EARContext earContext, ComponentContextBuilder builder, RefContext refContext, GerGbeanRefType[] gerGbeanRefs, ClassLoader cl) throws DeploymentException {
        if (null == gerGbeanRefs) {
            return;
        }
        for (int i = 0; i < gerGbeanRefs.length; ++i) {
            GerGbeanRefType gerGbeanRef = gerGbeanRefs[i];
            ENCConfigBuilder.addGBeanRef(earContext, builder, refContext, gerGbeanRef, cl);
        }
    }

    private static void addGBeanRef(EARContext earContext, ComponentContextBuilder builder, RefContext refContext, GerGbeanRefType gerGbeanRef, ClassLoader cl) throws DeploymentException {
        Class gBeanType;
        GBeanData gBeanData;
        GerPatternType[] gbeanLocatorArray = gerGbeanRef.getPatternArray();
        String[] interfaceTypesArray = gerGbeanRef.getRefTypeArray();
        HashSet<String> interfaceTypes = new HashSet<String>(Arrays.asList(interfaceTypesArray));
        HashSet<AbstractNameQuery> queries = new HashSet<AbstractNameQuery>();
        for (int i = 0; i < gbeanLocatorArray.length; ++i) {
            GerPatternType patternType = gbeanLocatorArray[i];
            AbstractNameQuery abstractNameQuery = ENCConfigBuilder.buildAbstractNameQuery(patternType, null, null, interfaceTypes);
            queries.add(abstractNameQuery);
        }
        Configuration configuration = earContext.getConfiguration();
        try {
            gBeanData = configuration.findGBeanData(queries);
        }
        catch (GBeanNotFoundException e) {
            throw new DeploymentException("Could not resolve reference at deploy time for queries " + queries, (Throwable)e);
        }
        if (interfaceTypes.isEmpty()) {
            interfaceTypes.add(gBeanData.getGBeanInfo().getClassName());
        }
        try {
            gBeanType = ClassLoading.loadClass((String)gBeanData.getGBeanInfo().getClassName(), (ClassLoader)cl);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Cannot load GBean class", (Throwable)e);
        }
        String refName = gerGbeanRef.getRefName();
        builder.bind(refName, (Object)new GBeanReference(configuration.getId(), queries, gBeanType));
    }

    private static Map mapEjbRefs(GerEjbRefType[] refs) {
        HashMap<String, GerEjbRefType> refMap = new HashMap<String, GerEjbRefType>();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                GerEjbRefType ref = refs[i];
                refMap.put(ref.getRefName().trim(), ref);
            }
        }
        return refMap;
    }

    private static Map mapEjbLocalRefs(GerEjbLocalRefType[] refs) {
        HashMap<String, GerEjbLocalRefType> refMap = new HashMap<String, GerEjbLocalRefType>();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                GerEjbLocalRefType ref = refs[i];
                refMap.put(ref.getRefName().trim(), ref);
            }
        }
        return refMap;
    }

    private static Map mapResourceRefs(GerResourceRefType[] refs) {
        HashMap<String, GerResourceRefType> refMap = new HashMap<String, GerResourceRefType>();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                GerResourceRefType ref = refs[i];
                refMap.put(ref.getRefName().trim(), ref);
            }
        }
        return refMap;
    }

    private static Map mapResourceEnvRefs(GerResourceEnvRefType[] refs) {
        HashMap<String, GerResourceEnvRefType> refMap = new HashMap<String, GerResourceEnvRefType>();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                GerResourceEnvRefType ref = refs[i];
                refMap.put(ref.getRefName().trim(), ref);
            }
        }
        return refMap;
    }

    private static Map mapServiceRefs(GerServiceRefType[] refs) {
        HashMap<String, GerServiceRefType> refMap = new HashMap<String, GerServiceRefType>();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                GerServiceRefType ref = refs[i];
                String serviceRefName = ref.getServiceRefName().trim();
                refMap.put(serviceRefName, ref);
            }
        }
        return refMap;
    }

    public static AbstractNameQuery buildAbstractNameQuery(GerPatternType pattern, String type, String moduleType, Set interfaceTypes) {
        String groupId = pattern.isSetGroupId() ? pattern.getGroupId().trim() : null;
        String artifactid = pattern.isSetArtifactId() ? pattern.getArtifactId().trim() : null;
        String version = pattern.isSetVersion() ? pattern.getVersion().trim() : null;
        String module = pattern.isSetModule() ? pattern.getModule().trim() : null;
        String name = pattern.getName().trim();
        Artifact artifact = artifactid != null ? new Artifact(groupId, artifactid, version, null) : null;
        HashMap<String, String> nameMap = new HashMap<String, String>();
        nameMap.put("name", name);
        if (type != null) {
            nameMap.put("j2eeType", type);
        }
        if (module != null && moduleType != null) {
            nameMap.put(moduleType, module);
        }
        if (interfaceTypes != null) {
            HashSet<String> trimmed = new HashSet<String>();
            Iterator it = interfaceTypes.iterator();
            while (it.hasNext()) {
                String intf = (String)it.next();
                trimmed.add(intf == null ? null : intf.trim());
            }
            interfaceTypes = trimmed;
        }
        return new AbstractNameQuery(artifact, nameMap, (Set)interfaceTypes);
    }

    public static AbstractNameQuery buildAbstractNameQuery(Artifact configId, String module, String name, String type, String moduleType) {
        HashMap<String, String> nameMap = new HashMap<String, String>();
        nameMap.put("name", name);
        if (type != null) {
            nameMap.put("j2eeType", type);
        }
        if (module != null) {
            nameMap.put(moduleType, module);
        }
        return new AbstractNameQuery(configId, nameMap);
    }
}

