/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jmxdebug.web.beanlib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.jmxdebug.web.beanlib.KernelHelper;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.management.State;

public class GBeanInfoHelper {
    private final ObjectName objectName;
    private final GBeanData info;
    private final Kernel kernel;

    public GBeanInfoHelper(KernelHelper kernelHelper, String name) throws Exception {
        this.kernel = kernelHelper.getKernel();
        if (this.kernel != null) {
            this.objectName = new ObjectName(name);
            this.info = this.kernel.getGBeanData(this.objectName);
        } else {
            this.objectName = null;
            this.info = null;
        }
    }

    public String getCanonicalName() {
        return this.objectName.getCanonicalName();
    }

    public String getDomain() {
        return this.objectName.getDomain();
    }

    public String getState() {
        try {
            return State.toString((int)this.kernel.getGBeanState(this.objectName));
        }
        catch (Exception e) {
            return "Could not get state: " + e.getMessage();
        }
    }

    public List getKeyProperties() {
        Hashtable<String, String> h = this.objectName.getKeyPropertyList();
        Iterator<String> it = h.keySet().iterator();
        ArrayList l = new ArrayList();
        while (it.hasNext()) {
            String key = it.next();
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("key", key);
            m.put("value", h.get(key));
            l.add(m);
        }
        return l;
    }

    public String getClassName() {
        return this.info.getGBeanInfo().getClassName();
    }

    public SortedMap getAttributes() {
        TreeMap attributes = new TreeMap(this.info.getAttributes());
        Iterator iterator = attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getValue() == null) {
                entry.setValue("(null)");
            }
            if (!(entry.getValue() instanceof Object[])) continue;
            entry.setValue(Arrays.asList((Object[])entry.getValue()));
        }
        return attributes;
    }

    public Set getOperationInfo() {
        return this.info.getGBeanInfo().getOperations();
    }
}

