/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jmxdebug.web.velocity;

import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.geronimo.jmxdebug.web.beanlib.MBeanInfoHelper;
import org.apache.geronimo.jmxdebug.web.beanlib.MBeanServerHelper;
import org.apache.geronimo.jmxdebug.web.velocity.BasicVelocityActionServlet;
import org.apache.velocity.VelocityContext;

public class DebugServlet
extends BasicVelocityActionServlet {
    public static String OBJECT_NAME_FILTER_KEY = "ObjectNameFilter";

    protected String getActionVerb() {
        return "action";
    }

    public void defaultAction(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String beanName = req.getParameter("MBeanName");
        String filterKey = req.getParameter(OBJECT_NAME_FILTER_KEY);
        if (filterKey == null || "".equals(filterKey)) {
            filterKey = "*:*";
        }
        VelocityContext vc = new VelocityContext();
        MBeanServerHelper kernelHelper = new MBeanServerHelper();
        vc.put("mbctx", (Object)kernelHelper);
        vc.put("encoder", (Object)new KickSunInHead());
        vc.put(OBJECT_NAME_FILTER_KEY, (Object)filterKey);
        if (beanName == null) {
            vc.put("template", (Object)"nobean.vm");
        } else {
            try {
                vc.put("beanInfo", (Object)new MBeanInfoHelper(kernelHelper, beanName));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            vc.put("template", (Object)"mbeaninfo.vm");
        }
        this.renderTemplate(req, res, vc, "index.vm");
    }

    public void unknownAction(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.defaultAction(req, res);
    }

    public class KickSunInHead {
        public String decode(String string) {
            return this.decode(string, "UTF-8");
        }

        public String decode(String string, String encoding) {
            if (string != null) {
                try {
                    return URLDecoder.decode(string, encoding);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        public String encode(String string) {
            return this.encode(string, "UTF-8");
        }

        public String encode(String string, String encoding) {
            if (string != null) {
                try {
                    return URLEncoder.encode(string, encoding);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return null;
        }
    }
}

