/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jmxdebug.web.beanlib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geronimo.jmxdebug.util.ObjectNameComparator;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.management.State;

public class MBeanServerHelper {
    private final Kernel kernel = Kernel.getSingleKernel();

    public Kernel getKernel() {
        return this.kernel;
    }

    public Collection getMBeans() {
        return this.getMBeans("*:*");
    }

    public Collection getMBeans(String filterString) {
        if (filterString == null) {
            filterString = "*:*";
        }
        if (this.kernel != null) {
            ObjectName filter = null;
            try {
                filter = new ObjectName(filterString);
                Set names = this.kernel.listGBeans(filter);
                ArrayList sortedNames = new ArrayList(names);
                Collections.sort(sortedNames, ObjectNameComparator.INSTANCE);
                return sortedNames;
            }
            catch (MalformedObjectNameException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("MBeanServerHelper : error : no mbean server");
        }
        return null;
    }

    public String getState(ObjectName name) {
        try {
            int state = (Integer)this.kernel.getAttribute(name, "state");
            return State.toString((int)state);
        }
        catch (Exception e) {
            return null;
        }
    }
}

