/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jmxdebug.web.beanlib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import org.apache.geronimo.jmxdebug.web.beanlib.AttributeData;
import org.apache.geronimo.jmxdebug.web.beanlib.MBeanServerHelper;

public class MBeanInfoHelper {
    private final ObjectName objectName;
    private final MBeanInfo info;
    private final MBeanServer server;

    public MBeanInfoHelper(MBeanServerHelper kernelHelper, String name) throws Exception {
        this.server = kernelHelper.getKernel().getMBeanServer();
        if (this.server != null) {
            this.objectName = new ObjectName(name);
            this.info = this.server.getMBeanInfo(this.objectName);
        } else {
            this.objectName = null;
            this.info = null;
        }
    }

    public String getCanonicalName() {
        return this.objectName.getCanonicalName();
    }

    public String getDomain() {
        return this.objectName.getDomain();
    }

    public List getKeyProperties() {
        Hashtable<String, String> h = this.objectName.getKeyPropertyList();
        Iterator<String> it = h.keySet().iterator();
        ArrayList l = new ArrayList();
        while (it.hasNext()) {
            String key = it.next();
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("key", key);
            m.put("value", h.get(key));
            l.add(m);
        }
        return l;
    }

    public String getDescription() {
        return this.info.getDescription();
    }

    public String getClassName() {
        return this.info.getClassName();
    }

    public SortedMap getAttributes() {
        TreeMap<String, AttributeData> attributes = new TreeMap<String, AttributeData>();
        MBeanAttributeInfo[] arr = this.info.getAttributes();
        for (int i = 0; i < arr.length; ++i) {
            MBeanAttributeInfo attribute = arr[i];
            String name = attribute.getName();
            if (!attribute.isReadable() && !attribute.isWritable() || name.startsWith("$")) continue;
            Object value = null;
            if (attribute.isReadable()) {
                try {
                    value = this.server.getAttribute(this.objectName, name);
                }
                catch (MBeanException e) {
                    e.printStackTrace();
                }
                catch (AttributeNotFoundException e) {
                    e.printStackTrace();
                }
                catch (InstanceNotFoundException e) {
                    e.printStackTrace();
                }
                catch (ReflectionException e) {
                    e.printStackTrace();
                }
                catch (RuntimeMBeanException rme) {
                    rme.printStackTrace();
                }
            }
            try {
                AttributeData attributeData = new AttributeData(attribute, value, this.server.getClassLoaderFor(this.objectName));
                attributes.put(name, attributeData);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return attributes;
    }

    public MBeanOperationInfo[] getOperationInfo() {
        return this.info.getOperations();
    }
}

